/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.salecon.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.salecon.payload.OrgGrossProfitRateSettingPayload;
import com.elitesland.tw.tw5.api.prd.salecon.query.OrgGrossProfitRateSettingQuery;
import com.elitesland.tw.tw5.api.prd.salecon.service.OrgGrossProfitRateSettingService;
import com.elitesland.tw.tw5.api.prd.salecon.vo.OrgGrossProfitRateSettingVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.salecon.convert.OrgGrossProfitRateSettingConvert;
import com.elitesland.tw.tw5.server.prd.salecon.dao.OrgGrossProfitRateSettingDAO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.OrgGrossProfitRateSettingDO;
import com.elitesland.tw.tw5.server.prd.salecon.repo.OrgGrossProfitRateSettingRepo;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class OrgGrossProfitRateSettingServiceImpl
extends BaseServiceImpl
implements OrgGrossProfitRateSettingService {
    private static final Logger log = LoggerFactory.getLogger(OrgGrossProfitRateSettingServiceImpl.class);
    private final OrgGrossProfitRateSettingRepo orgGrossProfitRateSettingRepo;
    private final OrgGrossProfitRateSettingDAO orgGrossProfitRateSettingDAO;

    public PagingVO<OrgGrossProfitRateSettingVO> queryPaging(OrgGrossProfitRateSettingQuery query) {
        return this.orgGrossProfitRateSettingDAO.queryPaging(query);
    }

    public List<OrgGrossProfitRateSettingVO> queryListDynamic(OrgGrossProfitRateSettingQuery query) {
        return this.orgGrossProfitRateSettingDAO.queryListDynamic(query);
    }

    public OrgGrossProfitRateSettingVO queryByKey(Long key) {
        OrgGrossProfitRateSettingDO entity = this.orgGrossProfitRateSettingRepo.findById(key).orElseGet(OrgGrossProfitRateSettingDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        OrgGrossProfitRateSettingVO vo = OrgGrossProfitRateSettingConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public OrgGrossProfitRateSettingVO insert(OrgGrossProfitRateSettingPayload payload) {
        this.checkDate(payload);
        OrgGrossProfitRateSettingDO entityDo = OrgGrossProfitRateSettingConvert.INSTANCE.toDo(payload);
        return OrgGrossProfitRateSettingConvert.INSTANCE.toVo((OrgGrossProfitRateSettingDO)this.orgGrossProfitRateSettingRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public OrgGrossProfitRateSettingVO update(OrgGrossProfitRateSettingPayload payload) {
        this.checkDate(payload);
        OrgGrossProfitRateSettingDO entity = this.orgGrossProfitRateSettingRepo.findById(payload.getId()).orElseGet(OrgGrossProfitRateSettingDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        OrgGrossProfitRateSettingDO entityDo = OrgGrossProfitRateSettingConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return OrgGrossProfitRateSettingConvert.INSTANCE.toVo((OrgGrossProfitRateSettingDO)this.orgGrossProfitRateSettingRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(OrgGrossProfitRateSettingPayload payload) {
        this.checkDate(payload);
        OrgGrossProfitRateSettingDO entity = this.orgGrossProfitRateSettingRepo.findById(payload.getId()).orElseGet(OrgGrossProfitRateSettingDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.orgGrossProfitRateSettingDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.orgGrossProfitRateSettingDAO.deleteSoft(keys);
        }
    }

    private void checkDate(OrgGrossProfitRateSettingPayload payload) {
        LocalDate startDate = payload.getStartDate();
        LocalDate endDate = payload.getEndDate();
        OrgGrossProfitRateSettingQuery query = new OrgGrossProfitRateSettingQuery();
        query.setWorkType(payload.getWorkType());
        query.setOrgId(payload.getOrgId());
        if (payload.getId() != null) {
            query.setNotInIds(Arrays.asList(payload.getId()));
        }
        List<OrgGrossProfitRateSettingVO> orgGrossProfitRateSettingVOS = this.queryListDynamic(query);
        orgGrossProfitRateSettingVOS.stream().forEach(vo -> {
            if (endDate.isBefore(vo.getStartDate()) || startDate.isAfter(vo.getEndDate())) {
                return;
            }
            throw TwException.error("", "\u8be5\u6570\u636e\u5b58\u5728\u65f6\u95f4\u4ea4\u53c9\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u4fdd\u5b58");
        });
    }

    public OrgGrossProfitRateSettingServiceImpl(OrgGrossProfitRateSettingRepo orgGrossProfitRateSettingRepo, OrgGrossProfitRateSettingDAO orgGrossProfitRateSettingDAO) {
        this.orgGrossProfitRateSettingRepo = orgGrossProfitRateSettingRepo;
        this.orgGrossProfitRateSettingDAO = orgGrossProfitRateSettingDAO;
    }
}

