/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.system.service;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemBusinessObjectPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemBusinessObjectQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemBusinessObjectService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemBusinessObjectVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemNewFunctionVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemPermissionFieldObjRoleFunctionVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemPermissionFieldVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemPermissionFunctionObjectVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.system.convert.PrdSystemBusinessObjectConvert;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemBusinessObjectDAO;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemNewFunctionDAO;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemPermissionFieldDAO;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemPermissionFunctionObjectDAO;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemPermissionTableFieldsDAO;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRoleDAO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemBusinessObjectDO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemBusinessObjectMenuDO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemNewFunctionDO;
import com.elitesland.tw.tw5.server.prd.system.repo.PrdSystemBusinessObjectRepo;
import com.elitesland.tw.tw5.server.prd.system.repo.PrdSystemNewFunctionRepo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class PrdSystemBusinessObjectServiceImpl
implements PrdSystemBusinessObjectService {
    private static final Logger log = LoggerFactory.getLogger(PrdSystemBusinessObjectServiceImpl.class);
    private final PrdSystemBusinessObjectRepo repo;
    private final PrdSystemBusinessObjectDAO dao;
    private final PrdSystemRoleDAO roleDAO;
    private final PrdSystemNewFunctionDAO newFunctionDAO;
    private final PrdSystemNewFunctionRepo newFunctionRepo;
    private final PrdSystemPermissionFunctionObjectDAO functionObjectDAO;
    private final PrdSystemPermissionFieldDAO fieldDAO;
    private final PrdSystemPermissionTableFieldsDAO tableFieldsDAO;

    @Transactional(rollbackFor={Exception.class})
    public PrdSystemBusinessObjectVO insert(PrdSystemBusinessObjectPayload payload) {
        this.check(payload);
        PrdSystemBusinessObjectDO entityDo = PrdSystemBusinessObjectConvert.INSTANCE.toDo(payload);
        this.repo.save(entityDo);
        return PrdSystemBusinessObjectConvert.INSTANCE.toVO(entityDo);
    }

    @Transactional(rollbackFor={Exception.class})
    public PrdSystemBusinessObjectVO update(PrdSystemBusinessObjectPayload payload) {
        this.checkUpdate(payload);
        PrdSystemBusinessObjectDO entity = this.repo.findById(payload.getId()).orElseGet(PrdSystemBusinessObjectDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        if (StringUtils.hasText((String)payload.getObjectCode()) && !entity.getObjectCode().equals(payload.getObjectCode())) {
            Assert.isNull((Object)this.dao.queryByObjectCode(payload.getObjectCode()), (String)"objectCode\u4e0d\u80fd\u91cd\u590d");
        }
        PrdSystemBusinessObjectDO entityDo = PrdSystemBusinessObjectConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        PrdSystemBusinessObjectDO save = (PrdSystemBusinessObjectDO)this.repo.save(entity);
        if (payload.getMenuIds() != null) {
            if (payload.getMenuIds().size() > 0) {
                ArrayList<PrdSystemBusinessObjectMenuDO> businessObjectMenuDOS = new ArrayList<PrdSystemBusinessObjectMenuDO>();
                for (Long menuId : payload.getMenuIds()) {
                    PrdSystemBusinessObjectMenuDO businessObjectMenuDO = new PrdSystemBusinessObjectMenuDO();
                    businessObjectMenuDO.setMenuId(menuId);
                    businessObjectMenuDO.setObjectId(payload.getId());
                    businessObjectMenuDOS.add(businessObjectMenuDO);
                }
                this.dao.deleteBusinessObjectMenusByObjectId(payload.getId());
                this.dao.saveBusinessObjectMenuAll(businessObjectMenuDOS);
            } else {
                this.dao.deleteBusinessObjectMenusByObjectId(payload.getId());
            }
        }
        PrdSystemBusinessObjectVO businessObjectVO = PrdSystemBusinessObjectConvert.INSTANCE.toVO(save);
        businessObjectVO.setMenuIds(payload.getMenuIds());
        return businessObjectVO;
    }

    private void checkUpdate(PrdSystemBusinessObjectPayload payload) {
        if (payload.getId() == null) {
            throw TwException.error("", "id\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public PagingVO<PrdSystemBusinessObjectVO> paging(PrdSystemBusinessObjectQuery query) {
        return this.dao.queryByKeyword(query);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!CollectionUtils.isEmpty(keys)) {
            this.dao.deleteSoft(keys);
        }
    }

    public PrdSystemBusinessObjectVO get(Long id) {
        PrdSystemBusinessObjectDO entity = this.repo.findById(id).orElseGet(PrdSystemBusinessObjectDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        PrdSystemBusinessObjectVO prdSystemBusinessObjectVO = PrdSystemBusinessObjectConvert.INSTANCE.toVO(entity);
        prdSystemBusinessObjectVO.setMenuIds(this.dao.queryBusinessObjectMenuIds(id));
        return prdSystemBusinessObjectVO;
    }

    private void check(PrdSystemBusinessObjectPayload payload) {
        if (!StringUtils.hasText((String)payload.getObjectCode())) {
            throw TwException.error("", "objectCode\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.hasText((String)payload.getObjectCode())) {
            Assert.isNull((Object)this.dao.queryByObjectCode(payload.getObjectCode()), (String)"objectCode\u5df2\u5b58\u5728");
        }
        if (!StringUtils.hasText((String)payload.getObjectName())) {
            throw TwException.error("", "objectName\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (payload.getObjectStatus() == null) {
            throw TwException.error("", "objectStatus\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)payload.getObjectVersion())) {
            throw TwException.error("", "objectVersion\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void autoCreate(Map<String, PrdSystemBusinessObjectPayload> map) {
        ArrayList<String> objectCodes = new ArrayList<String>(map.keySet());
        List<PrdSystemBusinessObjectVO> objectList = this.dao.queryByObjectCodes(objectCodes);
        List<PrdSystemBusinessObjectVO> deleteObjectList = this.dao.queryByNotObjectCodes(objectCodes);
        Map<String, PrdSystemBusinessObjectVO> objectMap = objectList.stream().collect(Collectors.toMap(PrdSystemBusinessObjectVO::getObjectCode, e -> e, (l, r) -> l));
        ArrayList insertList = new ArrayList();
        ArrayList updateList = new ArrayList();
        map.forEach((k, v) -> {
            if (objectMap.containsKey(k)) {
                PrdSystemBusinessObjectVO prdSystemBusinessObjectVO = (PrdSystemBusinessObjectVO)objectMap.get(k);
                PrdSystemBusinessObjectDO prdSystemBusinessObjectDO = (PrdSystemBusinessObjectDO)PrdSystemBusinessObjectConvert.INSTANCE.toEntity(prdSystemBusinessObjectVO);
                prdSystemBusinessObjectDO.setObjectName(v.getObjectName());
                updateList.add(prdSystemBusinessObjectDO);
            } else {
                PrdSystemBusinessObjectDO entityDo = PrdSystemBusinessObjectConvert.INSTANCE.toDo((PrdSystemBusinessObjectPayload)v);
                entityDo.setObjectStatus(0);
                entityDo.setObjectVersion("1.0");
                insertList.add(entityDo);
            }
        });
        this.dao.deleteByCodeNotIn(objectCodes);
        ArrayList<Long> deleteFucIds = new ArrayList<Long>();
        ArrayList<Long> deleteFucObjIds = new ArrayList<Long>();
        ArrayList<Long> deleteFieldIds = new ArrayList<Long>();
        ArrayList<Long> deleteTableFieldIds = new ArrayList<Long>();
        if (!CollectionUtils.isEmpty(deleteObjectList)) {
            List<PrdSystemPermissionFunctionObjectVO> functionObjectVOS;
            List functionDOS = this.newFunctionRepo.findAll();
            for (PrdSystemBusinessObjectVO objectVO : deleteObjectList) {
                for (PrdSystemNewFunctionDO functionDO : functionDOS) {
                    if (!functionDO.getObjectId().equals(objectVO.getId())) continue;
                    deleteFucIds.add(functionDO.getId());
                }
            }
            List<Long> ids = this.tableFieldsDAO.queryListByTableIds(deleteFucIds);
            deleteTableFieldIds.addAll(ids);
            if (!CollectionUtils.isEmpty((Collection)functionDOS) && !CollectionUtils.isEmpty(functionObjectVOS = this.functionObjectDAO.queryByFunctionId(deleteFucIds))) {
                for (PrdSystemPermissionFunctionObjectVO functionObjectVO : functionObjectVOS) {
                    deleteFucObjIds.add(functionObjectVO.getId());
                }
            }
            if (!CollectionUtils.isEmpty(deleteFucObjIds)) {
                List<PrdSystemPermissionFieldVO> fieldVOS = this.fieldDAO.queryByFunctionObjectIds(new HashSet<Long>(deleteFucObjIds));
                for (PrdSystemPermissionFieldVO fieldVO : fieldVOS) {
                    deleteFieldIds.add(fieldVO.getId());
                }
            }
            this.newFunctionDAO.deleteByIds(deleteFucIds);
            this.functionObjectDAO.deleteByIds(deleteFucObjIds);
            this.fieldDAO.deleteByIds(deleteFieldIds);
            this.tableFieldsDAO.deleteSoftCopy(deleteTableFieldIds);
        }
        if (!CollectionUtils.isEmpty(insertList)) {
            this.repo.saveAll(insertList);
        }
        if (!CollectionUtils.isEmpty(updateList)) {
            this.repo.saveAll(updateList);
        }
    }

    public List<PrdSystemBusinessObjectVO> listFunction() {
        List all = this.repo.findAll();
        ArrayList<PrdSystemBusinessObjectVO> result = new ArrayList<PrdSystemBusinessObjectVO>();
        for (PrdSystemBusinessObjectDO prdSystemBusinessObjectDO : all) {
            PrdSystemBusinessObjectVO entityVO = PrdSystemBusinessObjectConvert.INSTANCE.toVO(prdSystemBusinessObjectDO);
            entityVO.setFunctionList(this.dao.queryFunctionByObjectId(entityVO.getId()));
            result.add(entityVO);
        }
        return result;
    }

    @TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
    public PrdSystemBusinessObjectVO listObjectConfig(PrdSystemBusinessObjectQuery query) {
        this.checkListObjectConfig(query);
        PrdSystemBusinessObjectVO businessObjectVO = this.dao.queryByObjectCode(query.getObjectCode());
        Assert.notNull((Object)businessObjectVO, (String)"\u4e0d\u5b58\u5728");
        HashSet<Long> set = new HashSet<Long>();
        SysUserDTO user = GlobalUtil.getLoginGeneralUser().getUser();
        HashSet<Long> roleIds = user.getRoleIds();
        if (CollectionUtils.isEmpty((Collection)roleIds)) {
            roleIds = new HashSet<Long>(this.dao.getRoleIdsByUserId(user.getId()));
        }
        List<PrdSystemNewFunctionVO> functionVOS = this.dao.getDistinctFunctionByRoleIds((Set<Long>)roleIds);
        businessObjectVO.setFunctionList(functionVOS);
        List<PrdSystemPermissionFieldObjRoleFunctionVO> functionObjectVOS = this.roleDAO.queryFunctionObjectByFunctionIds(functionVOS.stream().map(BaseViewModel::getId).collect(Collectors.toList()));
        List<PrdSystemPermissionFieldObjRoleFunctionVO> fieldRuleVOS = this.dao.getDistinctFieldRuleByRoleIds(roleIds);
        for (PrdSystemPermissionFieldObjRoleFunctionVO functionObjectVO : functionObjectVOS) {
            for (PrdSystemPermissionFieldObjRoleFunctionVO fieldRuleVO : fieldRuleVOS) {
                if (set.contains(fieldRuleVO.getFieldId()) || !functionObjectVO.getFunctionObjectId().equals(fieldRuleVO.getFunctionObjectId())) continue;
                ArrayList<PrdSystemPermissionFieldObjRoleFunctionVO> field = functionObjectVO.getField();
                if (CollectionUtils.isEmpty((Collection)field)) {
                    field = new ArrayList<PrdSystemPermissionFieldObjRoleFunctionVO>();
                    functionObjectVO.setField(field);
                }
                field.add(fieldRuleVO);
                set.add(fieldRuleVO.getFieldId());
            }
        }
        businessObjectVO.setFieldRuleList(functionObjectVOS);
        return businessObjectVO;
    }

    public PrdSystemBusinessObjectVO listFunctionConfig(PrdSystemBusinessObjectQuery query) {
        this.checkListFunctionConfig(query);
        PrdSystemBusinessObjectVO businessObjectVO = this.dao.queryByObjectCode(query.getObjectCode());
        Assert.notNull((Object)businessObjectVO.getId(), (String)"\u4e0d\u5b58\u5728");
        PrdSystemNewFunctionVO newFunctionVO = this.newFunctionDAO.queryByFunctionCode(query.getFunctionCode());
        Assert.notNull((Object)newFunctionVO.getId(), (String)"\u4e0d\u5b58\u5728");
        HashSet<Long> set = new HashSet<Long>();
        SysUserDTO user = GlobalUtil.getLoginGeneralUser().getUser();
        HashSet<Long> roleIds = user.getRoleIds();
        if (CollectionUtils.isEmpty((Collection)roleIds)) {
            roleIds = new HashSet<Long>(this.dao.getRoleIdsByUserId(user.getId()));
        }
        List<PrdSystemNewFunctionVO> newFunctionVOS = this.dao.getDistinctFunctionByRoleIds((Set<Long>)roleIds);
        List<PrdSystemNewFunctionVO> newFunctionByRole = newFunctionVOS.stream().filter(function -> query.getFunctionCode().equals(function.getParentFunctionCode()) || query.getFunctionCode().equals(function.getFunctionCode())).toList();
        Boolean flag = this.checkContainsFunction(query, newFunctionVOS);
        if (!flag.booleanValue()) {
            businessObjectVO.setFunctionList(newFunctionByRole);
            businessObjectVO.setFieldRuleList(new ArrayList());
            return businessObjectVO;
        }
        List<PrdSystemPermissionFieldObjRoleFunctionVO> fieldRuleVOS = this.dao.getDistinctFieldRuleByRoleIds(roleIds);
        List<PrdSystemPermissionFieldObjRoleFunctionVO> functionObjectVOS = this.roleDAO.queryFunctionObjectByFunctionIds(List.of(newFunctionVO.getId()));
        for (PrdSystemPermissionFieldObjRoleFunctionVO functionObjectVO : functionObjectVOS) {
            for (PrdSystemPermissionFieldObjRoleFunctionVO fieldRuleVO : fieldRuleVOS) {
                if (set.contains(fieldRuleVO.getFieldId()) || !functionObjectVO.getFunctionObjectId().equals(fieldRuleVO.getFunctionObjectId())) continue;
                ArrayList<PrdSystemPermissionFieldObjRoleFunctionVO> field = functionObjectVO.getField();
                if (CollectionUtils.isEmpty((Collection)field)) {
                    field = new ArrayList<PrdSystemPermissionFieldObjRoleFunctionVO>();
                    functionObjectVO.setField(field);
                }
                field.add(fieldRuleVO);
                set.add(fieldRuleVO.getFieldId());
            }
        }
        businessObjectVO.setFieldRuleList(functionObjectVOS);
        businessObjectVO.setFunctionList(newFunctionByRole);
        return businessObjectVO;
    }

    public List<PrdSystemBusinessObjectVO> listFunction(PrdSystemBusinessObjectQuery query) {
        List<PrdSystemBusinessObjectVO> records = this.dao.findAll();
        List<PrdSystemNewFunctionVO> functions = this.dao.queryFunctionByHaveFunctionObject();
        HashSet<Long> functionSet = new HashSet<Long>();
        for (PrdSystemBusinessObjectVO record : records) {
            if (functionSet.size() == functions.size()) break;
            for (PrdSystemNewFunctionVO function : functions) {
                if (!record.getId().equals(function.getObjectId()) || functionSet.contains(function.getId())) continue;
                ArrayList<PrdSystemNewFunctionVO> functionList = record.getFunctionList();
                if (CollectionUtils.isEmpty((Collection)functionList)) {
                    functionList = new ArrayList<PrdSystemNewFunctionVO>();
                }
                functionList.add(function);
                record.setFunctionList(functionList);
                functionSet.add(function.getId());
            }
        }
        return records;
    }

    private void checkListFunctionConfig(PrdSystemBusinessObjectQuery query) {
        if (!StringUtils.hasText((String)query.getFunctionCode())) {
            throw TwException.error("", "functionCode\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)query.getObjectCode())) {
            throw TwException.error("", "objectCode\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void checkListObjectConfig(PrdSystemBusinessObjectQuery query) {
        if (!StringUtils.hasText((String)query.getObjectCode())) {
            throw TwException.error("", "objectCode\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private Boolean checkContainsFunction(PrdSystemBusinessObjectQuery query, List<PrdSystemNewFunctionVO> newFunctionVOS) {
        Boolean flag = false;
        for (PrdSystemNewFunctionVO vo : newFunctionVOS) {
            if (!query.getFunctionCode().equals(vo.getFunctionCode())) continue;
            flag = true;
        }
        return flag;
    }

    public PrdSystemBusinessObjectServiceImpl(PrdSystemBusinessObjectRepo repo, PrdSystemBusinessObjectDAO dao, PrdSystemRoleDAO roleDAO, PrdSystemNewFunctionDAO newFunctionDAO, PrdSystemNewFunctionRepo newFunctionRepo, PrdSystemPermissionFunctionObjectDAO functionObjectDAO, PrdSystemPermissionFieldDAO fieldDAO, PrdSystemPermissionTableFieldsDAO tableFieldsDAO) {
        this.repo = repo;
        this.dao = dao;
        this.roleDAO = roleDAO;
        this.newFunctionDAO = newFunctionDAO;
        this.newFunctionRepo = newFunctionRepo;
        this.functionObjectDAO = functionObjectDAO;
        this.fieldDAO = fieldDAO;
        this.tableFieldsDAO = tableFieldsDAO;
    }
}

