/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.system.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemSettingPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemSettingQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemSettingService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSettingVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.system.convert.PrdSystemSettingConvert;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemSettingDAO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemSettingDO;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PrdSystemSettingServiceImpl
implements PrdSystemSettingService {
    private static final Logger log = LoggerFactory.getLogger(PrdSystemSettingServiceImpl.class);
    private final PrdSystemSettingDAO dao;
    private final CacheUtil cacheUtil;

    @Transactional
    public PrdSystemSettingVO insert(PrdSystemSettingPayload payload) {
        String settingKey = payload.getSettingKey();
        PrdSystemSettingVO vo = this.dao.selectInspect(settingKey);
        if (vo == null) {
            PrdSystemSettingDO ado = PrdSystemSettingConvert.INSTANCE.toDo(payload);
            this.dao.save(ado);
            this.cacheUtil.loadSystemSettingCache();
            return PrdSystemSettingConvert.INSTANCE.toVo(ado);
        }
        throw TwException.error("", "\u7f16\u53f7\u4e0d\u53ef\u91cd\u590d");
    }

    @Transactional
    public Long update(PrdSystemSettingPayload payload) {
        Long key = payload.getId();
        String settingKey = payload.getSettingKey();
        PrdSystemSettingVO vo = this.dao.selectInspect(settingKey);
        if (vo == null) {
            this.dao.updateByKeyDynamic(payload);
            this.cacheUtil.loadSystemSettingCache();
            return 0L;
        }
        if (key.equals(vo.getId())) {
            this.dao.updateByKeyDynamic(payload);
            this.cacheUtil.loadSystemSettingCache();
            return 0L;
        }
        throw TwException.error("", "\u7f16\u53f7\u4e0d\u53ef\u91cd\u590d");
    }

    @Transactional
    public boolean delete(List<Long> keys) {
        this.dao.delete(keys);
        this.cacheUtil.loadSystemSettingCache();
        return true;
    }

    public PrdSystemSettingVO queryByKey(Long key) {
        return this.dao.queryByKey(key);
    }

    public PagingVO<PrdSystemSettingVO> paging(PrdSystemSettingQuery query) {
        PagingVO<PrdSystemSettingVO> evo = this.dao.queryPaging(query);
        List vos = evo.getRecords();
        for (PrdSystemSettingVO vo : vos) {
            vo.setSystemModuleName(this.cacheUtil.transferSystemSelection("BUSINESS_MODULE", vo.getSystemModule()));
        }
        return evo;
    }

    public PrdSystemSettingVO getSystemSettingByKey(String key) {
        return this.cacheUtil.getSystemSetting(key);
    }

    public void clearCache() {
        this.cacheUtil.loadSystemSettingCache();
    }

    public List<PrdSystemSettingVO> queryList(PrdSystemSettingQuery query) {
        return this.dao.queryListDynamic(query);
    }

    public PrdSystemSettingServiceImpl(PrdSystemSettingDAO dao, CacheUtil cacheUtil) {
        this.dao = dao;
        this.cacheUtil = cacheUtil;
    }
}

