/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.workflow;

import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.prd.work.dao.OvertimeApplicationDAO;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rpc/workflow/OVERTIME_APPLICATION/callBack"})
@Transactional
public class OvertimeApplicationWorkflowCallBackController
implements WorkflowCallBack {
    private static final Logger log = LoggerFactory.getLogger(OvertimeApplicationWorkflowCallBackController.class);
    private final OvertimeApplicationDAO overtimeApplicationDAO;

    @PostMapping(value={"/taskAssignee"})
    public WorkflowResult<ArrayList<String>> taskAssignee(@RequestBody TaskAssigneePayload payload) {
        log.info("\u52a8\u6001\u6307\u5b9a\u4efb\u52a1\u8d1f\u8d23\u4eba\u53c2\u6570: {}", (Object)payload);
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/taskCreated"})
    public WorkflowResult<Void> taskCreated(@RequestBody TaskCreatedPayload payload) {
        log.info("\u4efb\u52a1\u521b\u5efa\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/taskCompleted"})
    public WorkflowResult<Void> taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("\u4efb\u52a1\u5b8c\u6210\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/processStatusChange"})
    public WorkflowResult<Void> processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        log.info("\u6d41\u7a0b\u72b6\u6001\u53d8\u5316\u56de\u8c03\u53c2\u6570:{}", (Object)payload);
        String businessKey = payload.getBusinessKey();
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        String approve_status = null;
        switch (procInstStatus) {
            case NOTSUBMIT: {
                approve_status = WorkFlowStatusEnum.NOTSUBMIT.getCode();
                break;
            }
            case INTERRUPT: {
                break;
            }
            case INVALID: {
                approve_status = WorkFlowStatusEnum.INVALID.getCode();
                break;
            }
            case REJECTED: {
                approve_status = WorkFlowStatusEnum.REJECTED_WORK.getCode();
                break;
            }
            case APPROVED: {
                approve_status = WorkFlowStatusEnum.APPROVED.getCode();
                break;
            }
            case APPROVING: {
                approve_status = WorkFlowStatusEnum.APPROVING_WORK.getCode();
            }
        }
        this.overtimeApplicationDAO.updateStatusById(approve_status, Long.valueOf(businessKey));
        return WorkflowResult.success(null);
    }

    public OvertimeApplicationWorkflowCallBackController(OvertimeApplicationDAO overtimeApplicationDAO) {
        this.overtimeApplicationDAO = overtimeApplicationDAO;
    }
}

