package com.elitesland.tw.tw5.server.common.crontask.payload;


import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * 采购需求明细
 */
@Data
public class TwProcurDemandDView {

    /**
     * id
     */
    private Long id;

    /**
     * 采购需求id
     */
    private Long procurDemandId;

    /**
     * 序号
     */
    private String sortNo;

    /**
     * 建议供应商ID
     */
    private Long supplierId;

    private String supplierName;

    /**
     * 需求说明
     */
    private String demandSaid;

    /**
     *关联产品
     */
    private Long buProdId;

    private String buProdName;

    /**
     * 产品大类id
     */
    private Long classId;
    private String productClass;

    /**
     * 产品大类名称
     */
    private String className;

    /**
     * 产品小类id
     */
    private Long subClassId;
    private String productSubClass;

    /**
     * 产品小类名称
     */
    private String subClassName;

    /**
     * 数量
     */
    private BigDecimal  demandNum;

    /**
     * 含税单价
     */
    private BigDecimal taxPrice;

    /**
     * 货币
     */
    private String symbol;

    /**
     * 税率
     */
    private BigDecimal taxRate;

    /**
     * 含税总额
     */
    private BigDecimal taxAmt;

    /**
     * 不含税总额 不含税金额 （= 含税总金额 ÷ (1+税率%））
     */
    private BigDecimal taxNotamt;

    /**
     * 采购合同编号
     */
    private String contractNo;

    /**
     * 采购合同ID
     */
    private Long purContractId;

    /**
     * 产品小类list
     */
    private List<TwClassView> subTreeData;

    /**
     * 供应商 法人编号
     */
    private String legalAbNo;

    /**
     * 合同id
     */
    private Long contractId;

    /**
     * 删除标志
     */
    private Integer delFlag;

    /**
     * 采购需求明细ID_V5
     */
    private Long demandDIdV5;

    /**
     * 采购需求明细ID_V4
     */
    private Long demandDIdV4;

}
