package com.elitesland.tw.tw5.server.common.funConfig.controller;

import com.elitesland.tw.tw5.api.common.funConfig.payload.BusinessDocTypeConfigPathExprPayload;
import com.elitesland.tw.tw5.api.common.funConfig.query.BusinessDocTypeConfigPathExprQuery;
import com.elitesland.tw.tw5.api.common.funConfig.vo.BusinessDocTypeConfigPathExprVO;
import com.elitesland.tw.tw5.api.common.funConfig.service.BusinessDocTypeConfigPathExprService;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitescloud.cloudt.common.base.PagingVO;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 文档配置函数表达式
 *
 * @folder 文档配置函数表达式
 * @author wangly
 * @date 2024-07-02
 */
@Api(tags = "文档配置函数表达式")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/businessDocTypeConfigPathExpr")
@Slf4j
public class BusinessDocTypeConfigPathExprController {

private final BusinessDocTypeConfigPathExprService businessDocTypeConfigPathExprService;

    /**
     * 文档配置函数表达式-新增
     *
     * @folder 文档配置函数表达式
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("文档配置函数表达式-新增")
    public TwOutputUtil<BusinessDocTypeConfigPathExprVO> insert(@RequestBody BusinessDocTypeConfigPathExprPayload payload){
         return TwOutputUtil.ok(businessDocTypeConfigPathExprService.insert(payload));
    }

    /**
     * 文档配置函数表达式-更新
     *
         * @folder 文档配置函数表达式
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("文档配置函数表达式-更新")
    public TwOutputUtil<BusinessDocTypeConfigPathExprVO> update(@RequestBody BusinessDocTypeConfigPathExprPayload payload){
        return TwOutputUtil.ok(businessDocTypeConfigPathExprService.update(payload));
    }

    /**
     * 文档配置函数表达式-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @folder 文档配置函数表达式
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("文档配置函数表达式-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody BusinessDocTypeConfigPathExprPayload payload){
        return TwOutputUtil.ok(businessDocTypeConfigPathExprService.updateByKeyDynamic(payload));
    }

    /**
     * 文档配置函数表达式-主键查询
     *
     * @folder 文档配置函数表达式
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("文档配置函数表达式-主键查询")
    public TwOutputUtil<BusinessDocTypeConfigPathExprVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(businessDocTypeConfigPathExprService.queryByKey(key));
    }

    /**
     * 文档配置函数表达式-分页
     *
         * @folder 文档配置函数表达式
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("文档配置函数表达式-分页")
    public TwOutputUtil<PagingVO<BusinessDocTypeConfigPathExprVO>> paging(BusinessDocTypeConfigPathExprQuery query) {
        return TwOutputUtil.ok(businessDocTypeConfigPathExprService.queryPaging(query));
    }

    /**
     * 文档配置函数表达式-查询列表
     *
     * @folder 文档配置函数表达式
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("文档配置函数表达式-查询列表")
    public TwOutputUtil<List<BusinessDocTypeConfigPathExprVO>> queryList(BusinessDocTypeConfigPathExprQuery query) {
        return TwOutputUtil.ok(businessDocTypeConfigPathExprService.queryListDynamic(query));
    }

    /**
     * 文档配置函数表达式-删除
     *
         * @folder 文档配置函数表达式
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("文档配置函数表达式-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
         businessDocTypeConfigPathExprService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }
}

