package com.elitesland.tw.tw5.server.common.permission;

import cn.zhxu.bs.BeanSearcher;
import cn.zhxu.bs.SearchResult;
import cn.zhxu.bs.util.FieldFns;
import cn.zhxu.bs.util.MapBuilder;
import cn.zhxu.bs.util.MapUtils;
import com.elitesland.tw.tw5.server.common.StringUtil;
import com.elitesland.tw.tw5.server.common.permission.service.PermissionRuleService;
import org.springframework.util.ObjectUtils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

import static com.elitesland.tw.tw5.server.common.permission.contants.PermissionContants.FUNCTION_CODE;
import static com.elitesland.tw.tw5.server.common.permission.contants.PermissionContants.PERMISSION_CHECK;

/**
 * 数据权限 BeanSearcher 实现
 *
 * @author : JS
 * @date 2023/09/25
 */
public class PermissionBeanSearcher implements BeanSearcher {

    private final BeanSearcher beanSearcher;

    private final PermissionRuleService permissionRuleService;

    private final String permissionDomainCode;

    public PermissionBeanSearcher(BeanSearcher beanSearcher, PermissionRuleService permissionRuleService, String permissionDomainCode) {
        this.beanSearcher = beanSearcher;
        this.permissionRuleService = permissionRuleService;
        this.permissionDomainCode = permissionDomainCode;
    }

    @Override
    public <T> SearchResult<T> search(Class<T> beanClass) {
        return search(beanClass, new HashMap<>());
    }

    @Override
    public <T> SearchResult<T> search(Class<T> beanClass, Map<String, Object> paraMap) {
        MapBuilder permissionMapBuilder = permissionMapBuilder(beanClass, paraMap);
        return beanSearcher.search(beanClass, permissionMapBuilder.build());
    }

    @Override
    public <T> SearchResult<T> search(Class<T> beanClass, String summaryField) {
        return search(beanClass, new HashMap<>(), summaryField);
    }

    @Override
    public <T> SearchResult<T> search(Class<T> beanClass, Map<String, Object> paraMap, String summaryField) {
        MapBuilder permissionMapBuilder = permissionMapBuilder(beanClass, paraMap);
        return beanSearcher.search(beanClass, permissionMapBuilder.build(), summaryField);
    }

    @Override
    public <T> SearchResult<T> search(Class<T> beanClass, FieldFns.FieldFn<T, ?> summaryField) {
        return search(beanClass, new HashMap<>(), summaryField);
    }

    @Override
    public <T> SearchResult<T> search(Class<T> beanClass, Map<String, Object> paraMap, FieldFns.FieldFn<T, ?> summaryField) {
        MapBuilder permissionMapBuilder = permissionMapBuilder(beanClass, paraMap);
        return beanSearcher.search(beanClass, permissionMapBuilder.build(), summaryField);
    }

    @Override
    public <T> SearchResult<T> search(Class<T> beanClass, String[] summaryFields) {
        return search(beanClass, new HashMap<>(), summaryFields);
    }

    @Override
    public <T> SearchResult<T> search(Class<T> beanClass, Map<String, Object> paraMap, String[] summaryFields) {
        MapBuilder permissionMapBuilder = permissionMapBuilder(beanClass, paraMap);
        return beanSearcher.search(beanClass, permissionMapBuilder.build(), summaryFields);
    }

    @Override
    public <T> T searchFirst(Class<T> beanClass) {
        return searchFirst(beanClass, new HashMap<>());
    }

    @Override
    public <T> T searchFirst(Class<T> beanClass, Map<String, Object> paraMap) {
        MapBuilder permissionMapBuilder = permissionMapBuilder(beanClass, paraMap);
        return beanSearcher.searchFirst(beanClass, permissionMapBuilder.build());
    }

    @Override
    public <T> List<T> searchList(Class<T> beanClass) {
        return searchList(beanClass, new HashMap<>());
    }

    @Override
    public <T> List<T> searchList(Class<T> beanClass, Map<String, Object> paraMap) {
        MapBuilder permissionMapBuilder = permissionMapBuilder(beanClass, paraMap);
        return beanSearcher.searchList(beanClass, permissionMapBuilder.build());
    }

    @Override
    public <T> List<T> searchAll(Class<T> beanClass) {
        return searchAll(beanClass, new HashMap<>());
    }

    @Override
    public <T> List<T> searchAll(Class<T> beanClass, Map<String, Object> paraMap) {
        MapBuilder permissionMapBuilder = permissionMapBuilder(beanClass, paraMap);
        return beanSearcher.searchAll(beanClass, permissionMapBuilder.build());
    }

    @Override
    public <T> Number searchCount(Class<T> beanClass) {
        return searchCount(beanClass, new HashMap<>());
    }

    @Override
    public <T> Number searchCount(Class<T> beanClass, Map<String, Object> paraMap) {
        MapBuilder permissionMapBuilder = permissionMapBuilder(beanClass, paraMap);
        return beanSearcher.searchCount(beanClass, permissionMapBuilder.build());
    }

    @Override
    public <T> Number searchSum(Class<T> beanClass, String field) {
        return searchSum(beanClass, new HashMap<>(), field);
    }

    @Override
    public <T> Number searchSum(Class<T> beanClass, Map<String, Object> paraMap, String field) {
        MapBuilder permissionMapBuilder = permissionMapBuilder(beanClass, paraMap);
        return beanSearcher.searchSum(beanClass, permissionMapBuilder.build(), field);
    }

    @Override
    public <T> Number searchSum(Class<T> beanClass, FieldFns.FieldFn<T, ?> field) {
        return searchSum(beanClass, new HashMap<>(), field);
    }

    @Override
    public <T> Number searchSum(Class<T> beanClass, Map<String, Object> paraMap, FieldFns.FieldFn<T, ?> field) {
        MapBuilder permissionMapBuilder = permissionMapBuilder(beanClass, paraMap);
        return beanSearcher.searchSum(beanClass, permissionMapBuilder.build(), field);
    }

    @Override
    public <T> Number[] searchSum(Class<T> beanClass, String[] fields) {
        return searchSum(beanClass, new HashMap<>(), fields);
    }

    @Override
    public <T> Number[] searchSum(Class<T> beanClass, Map<String, Object> paraMap, String[] fields) {
        MapBuilder permissionMapBuilder = permissionMapBuilder(beanClass, paraMap);
        return beanSearcher.searchSum(beanClass, permissionMapBuilder.build(), fields);
    }

    private <T> MapBuilder permissionMapBuilder(Class<T> beanClass, Map<String, Object> paraMap) {
        if (!paraMap.containsKey(FUNCTION_CODE) || ObjectUtils.isEmpty(paraMap.get(FUNCTION_CODE))) {
            return MapUtils.builder(paraMap);
        }
        if(permissionDomainCode == null || "".equals(permissionDomainCode)){
            throw new RuntimeException("PermissionBeanSearcher未配置业务对象！");
        }
        if(StringUtil.isEmpty(paraMap.get(FUNCTION_CODE).toString())){
            throw new RuntimeException("功能代码不能为空！");
        }
        // 已做过权限校验的参数无需重复校验
        if(paraMap.containsKey(PERMISSION_CHECK) && (boolean)paraMap.get(PERMISSION_CHECK)){
            return MapUtils.builder(paraMap);
        }

        return permissionRuleService.searcherHandle(beanClass, paraMap, permissionDomainCode);
    }
}
