package com.elitesland.tw.tw5.server.prd.acc.controller;


import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimSettingContinuousPayload;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimSettingContinuousQuery;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimSettingQuery;
import com.elitesland.tw.tw5.api.prd.acc.service.AccReimSettingContinuousService;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimSettingContinuousVO;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimSettingVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitescloud.cloudt.common.base.PagingVO;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 报销配置连号规则配置
 *
 * @author zoey
 * @date 2024-04-16
 */
@Api(tags = "报销配置连号规则配置")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/accReimSettingContinuous")
@Slf4j
public class AccReimSettingContinuousController {

private final AccReimSettingContinuousService accReimSettingContinuousService;

    /**
     * 报销配置连号规则配置-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("报销配置连号规则配置-新增")
    public TwOutputUtil<AccReimSettingContinuousVO> insert(@RequestBody AccReimSettingContinuousPayload payload){
         return TwOutputUtil.ok(accReimSettingContinuousService.insert(payload));
    }

    /**
     * 报销配置连号规则配置-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("报销配置连号规则配置-更新")
    public TwOutputUtil<AccReimSettingContinuousVO> update(@RequestBody AccReimSettingContinuousPayload payload){
        return TwOutputUtil.ok(accReimSettingContinuousService.update(payload));
    }

    /**
     * 报销配置连号规则配置-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("报销配置连号规则配置-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody AccReimSettingContinuousPayload payload){
        return TwOutputUtil.ok(accReimSettingContinuousService.updateByKeyDynamic(payload));
    }

    /**
     * 报销配置连号规则配置-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("报销配置连号规则配置-主键查询")
    public TwOutputUtil<AccReimSettingContinuousVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(accReimSettingContinuousService.queryByKey(key));
    }

    /**
     * 报销配置连号规则配置-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("报销配置连号规则配置-分页")
    public TwOutputUtil<PagingVO<AccReimSettingContinuousVO>> paging(AccReimSettingContinuousQuery query) {
        return TwOutputUtil.ok(accReimSettingContinuousService.queryPaging(query));
    }

    /**
     * 报销配置连号规则配置-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("报销配置连号规则配置-查询列表")
    public TwOutputUtil<List<AccReimSettingContinuousVO>> queryList(AccReimSettingContinuousQuery query) {
        return TwOutputUtil.ok(accReimSettingContinuousService.queryListDynamic(query));
    }

    /**
     * 报销配置连号规则配置-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("报销配置连号规则配置-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
         accReimSettingContinuousService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }


    /**
     * 报销配置连号规则配置-规则检查
     *
     * @param key 有效载荷
     * @param invoiceNo 有效载荷
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/ruleCheck/{key}/{invoiceNo}")
    @ApiOperation("报销配置连号规则配置-规则检查")
    public TwOutputUtil<AccReimSettingContinuousVO> ruleCheck(@PathVariable Long key,@PathVariable String invoiceNo,Long reimUserId){
        return null;
//        return TwOutputUtil.ok(accReimSettingContinuousService.ruleCheck(key,invoiceNo,reimUserId));
    }

}

