package com.elitesland.tw.tw5.server.prd.acc.controller;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimSettingCheckPayload;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimSettingPayload;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimSettingQuery;
import com.elitesland.tw.tw5.api.prd.acc.service.AccReimSettingService;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimSettingVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 * 报销配置主表
 *
 * @author zoey
 * @date 2024-04-08
 */
@Api(tags = "报销配置主表")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/accReimSetting")
@Slf4j
public class AccReimSettingController {

    private final AccReimSettingService accReimSettingService;

    /**
     * 报销配置主表-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("报销配置主表-新增")
    public TwOutputUtil<AccReimSettingVO> insert(@RequestBody AccReimSettingPayload payload) {
        return TwOutputUtil.ok(accReimSettingService.insert(payload));
    }

    /**
     * 报销配置主表-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("报销配置主表-更新")
    public TwOutputUtil<AccReimSettingVO> update(@RequestBody AccReimSettingPayload payload) {
        return TwOutputUtil.ok(accReimSettingService.update(payload));
    }

    /**
     * 报销配置主表-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("报销配置主表-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody AccReimSettingPayload payload) {
        return TwOutputUtil.ok(accReimSettingService.updateByKeyDynamic(payload));
    }

    /**
     * 报销配置主表-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("报销配置主表-主键查询")
    public TwOutputUtil<AccReimSettingVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(accReimSettingService.queryByKey(key));
    }

    /**
     * 报销配置主表-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("报销配置主表-分页")
    public TwOutputUtil<PagingVO<AccReimSettingVO>> paging(AccReimSettingQuery query) {
        return TwOutputUtil.ok(accReimSettingService.queryPaging(query));
    }

    /**
     * 报销配置主表-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("报销配置主表-查询列表")
    public TwOutputUtil<List<AccReimSettingVO>> queryList(AccReimSettingQuery query) {
        return TwOutputUtil.ok(accReimSettingService.queryListDynamic(query));
    }


    /**
     * 报销配置主表-多条件查询具体配置
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/queryBaseSetting")
    @UdcNameClass
    @ApiOperation("报销配置主表-查询列表")
    public TwOutputUtil<AccReimSettingVO> queryBaseSetting(AccReimSettingQuery query) {
        query.setEffective(1);
        return TwOutputUtil.ok(accReimSettingService.queryBaseSetting(query));
    }

    /**
     * 报销配置主表-多条件查询具体配置
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/queryBaseSettings")
    @UdcNameClass
    @ApiOperation("报销配置主表-查询列表")
    public TwOutputUtil<Map<String, AccReimSettingVO>> queryBaseSettings(AccReimSettingQuery query) {
        query.setEffective(1);
        return TwOutputUtil.ok(accReimSettingService.queryBaseSettings(query));
    }


    /**
     * 报销配置主表-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("报销配置主表-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        accReimSettingService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }


    /**
     * 公共配置查询-规则检查
     *
     * @return {@link TwOutputUtil}
     */
    @PostMapping("/ruleCheck")
    @ApiOperation("报销额度配置-规则检查")
    public TwOutputUtil<Map<String, Object>> ruleCheck(@RequestBody AccReimSettingCheckPayload reimSettingCheckPayload) {
        return TwOutputUtil.ok(accReimSettingService.ruleCheck(reimSettingCheckPayload));
    }
}

