package com.elitesland.tw.tw5.server.prd.acc.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimItemConfigRefPayload;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimItemConfigRefQuery;
import com.elitesland.tw.tw5.api.prd.acc.service.AccReimItemConfigRefService;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimItemConfigRefVO;
import com.elitesland.tw.tw5.server.prd.acc.convert.AccReimItemConfigRefConvert;
import com.elitesland.tw.tw5.server.prd.acc.dao.AccReimItemConfigRefDAO;
import com.elitesland.tw.tw5.server.prd.acc.entity.AccReimItemConfigRefDO;
import com.elitesland.tw.tw5.server.prd.acc.repo.AccReimItemConfigRefRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.List;

/**
 * 报销科目配置与核算项目管理
 *
 * @author sunxw
 * @date 2023-12-15
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class AccReimItemConfigRefServiceImpl extends BaseServiceImpl implements AccReimItemConfigRefService {

    private final AccReimItemConfigRefRepo repo;
    private final AccReimItemConfigRefDAO dao;

    @Override
    public PagingVO<AccReimItemConfigRefVO> queryPaging(AccReimItemConfigRefQuery query) {
        return dao.queryPaging(query);
    }

    @Override
    public List<AccReimItemConfigRefVO> queryListDynamic(AccReimItemConfigRefQuery query) {
        return dao.queryListDynamic(query);
    }

    @Override
    public AccReimItemConfigRefVO queryByKey(Long key) {
        return dao.queryByKey(key);
    }

    @Override
    @Transactional
    public AccReimItemConfigRefVO insert(AccReimItemConfigRefPayload payload) {
        AccReimItemConfigRefDO entityDo = AccReimItemConfigRefConvert.INSTANCE.toDo(payload);
        return AccReimItemConfigRefConvert.INSTANCE.toVo(repo.save(entityDo));
    }

    @Override
    public void batchInsert(List<AccReimItemConfigRefPayload> payloads) {
        List<AccReimItemConfigRefDO> dos = AccReimItemConfigRefConvert.INSTANCE.payloads2DOs(payloads);
        dao.saveAll(dos);
    }

    @Override
    @Transactional
    public AccReimItemConfigRefVO update(AccReimItemConfigRefPayload payload) {
        AccReimItemConfigRefDO entity = repo.findById(payload.getId()).orElseGet(AccReimItemConfigRefDO::new);
        Assert.notNull(entity.getId(), "不存在");
        AccReimItemConfigRefDO entityDo = AccReimItemConfigRefConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return AccReimItemConfigRefConvert.INSTANCE.toVo(repo.save(entity));
    }

    @Override
    @Transactional
    public long updateByKeyDynamic(AccReimItemConfigRefPayload payload) {
        AccReimItemConfigRefDO entity = repo.findById(payload.getId()).orElseGet(AccReimItemConfigRefDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = dao.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            dao.deleteSoft(keys);
        }
    }

    @Override
    @Transactional
    public void delByReimConfigId(Long reimConfigId) {
        dao.delByReimConfigId(reimConfigId);
    }

}
