package com.elitesland.tw.tw5.server.prd.acc.service;


import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimSettingOverdueDiscuntPayload;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimSettingOverdueDiscuntQuery;
import com.elitesland.tw.tw5.api.prd.acc.service.AccReimSettingOverdueDiscuntService;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimSettingOverdueDiscuntVO;
import com.elitesland.tw.tw5.server.prd.acc.convert.AccReimSettingOverdueDiscuntConvert;
import com.elitesland.tw.tw5.server.prd.acc.dao.AccReimSettingOverdueDiscuntDAO;
import com.elitesland.tw.tw5.server.prd.acc.entity.AccReimSettingOverdueDiscuntDO;
import com.elitesland.tw.tw5.server.prd.acc.repo.AccReimSettingOverdueDiscuntRepo;
import org.springframework.stereotype.Service;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import org.springframework.transaction.annotation.Transactional;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import javax.servlet.http.HttpServletResponse;
import java.util.*;

/**
 * 报销逾期打折表
 *
 * @author zoey
 * @date 2024-04-08
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class AccReimSettingOverdueDiscuntServiceImpl extends BaseServiceImpl implements AccReimSettingOverdueDiscuntService {

    private final AccReimSettingOverdueDiscuntRepo accReimSettingOverdueDiscuntRepo;
    private final AccReimSettingOverdueDiscuntDAO accReimSettingOverdueDiscuntDAO;

    @Override
    public PagingVO<AccReimSettingOverdueDiscuntVO> queryPaging(AccReimSettingOverdueDiscuntQuery query){
        return accReimSettingOverdueDiscuntDAO.queryPaging(query);
    }

    @Override
    public List<AccReimSettingOverdueDiscuntVO> queryListDynamic(AccReimSettingOverdueDiscuntQuery query){
        return accReimSettingOverdueDiscuntDAO.queryListDynamic(query);
    }

    @Override
    public AccReimSettingOverdueDiscuntVO queryByKey(Long key) {
        AccReimSettingOverdueDiscuntDO entity = accReimSettingOverdueDiscuntRepo.findById(key).orElseGet(AccReimSettingOverdueDiscuntDO::new);
        Assert.notNull(entity.getId(), "不存在");
        AccReimSettingOverdueDiscuntVO vo = AccReimSettingOverdueDiscuntConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public AccReimSettingOverdueDiscuntVO insert(AccReimSettingOverdueDiscuntPayload payload) {
        AccReimSettingOverdueDiscuntDO entityDo = AccReimSettingOverdueDiscuntConvert.INSTANCE.toDo(payload);
        return AccReimSettingOverdueDiscuntConvert.INSTANCE.toVo(accReimSettingOverdueDiscuntRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public AccReimSettingOverdueDiscuntVO update(AccReimSettingOverdueDiscuntPayload payload) {
        AccReimSettingOverdueDiscuntDO entity = accReimSettingOverdueDiscuntRepo.findById(payload.getId()).orElseGet(AccReimSettingOverdueDiscuntDO::new);
        Assert.notNull(entity.getId(), "不存在");
        AccReimSettingOverdueDiscuntDO entityDo = AccReimSettingOverdueDiscuntConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return AccReimSettingOverdueDiscuntConvert.INSTANCE.toVo(accReimSettingOverdueDiscuntRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(AccReimSettingOverdueDiscuntPayload payload) {
        AccReimSettingOverdueDiscuntDO entity = accReimSettingOverdueDiscuntRepo.findById(payload.getId()).orElseGet(AccReimSettingOverdueDiscuntDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = accReimSettingOverdueDiscuntDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            accReimSettingOverdueDiscuntDAO.deleteSoft(keys);
        }
    }

}
