package com.elitesland.tw.tw5.server.prd.acc.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimTaxPayload;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimTaxQuery;
import com.elitesland.tw.tw5.api.prd.acc.service.AccReimTaxService;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimExportVO;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimTaxVO;
import com.elitesland.tw.tw5.api.prd.inv.query.InvInvoiceQuery;
import com.elitesland.tw.tw5.api.prd.inv.service.InvInvoiceService;
import com.elitesland.tw.tw5.api.prd.inv.vo.InvInvoiceVO;
import com.elitesland.tw.tw5.server.prd.acc.convert.AccReimTaxConvert;
import com.elitesland.tw.tw5.server.prd.acc.dao.AccReimTaxDAO;
import com.elitesland.tw.tw5.server.prd.acc.entity.AccReimTaxDO;
import com.elitesland.tw.tw5.server.prd.acc.repo.AccReimTaxRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 费用报销税额管理
 *
 * @author sunxw
 * @date 2023-12-05
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class AccReimTaxServiceImpl extends BaseServiceImpl implements AccReimTaxService {

    private final AccReimTaxRepo repo;
    private final AccReimTaxDAO dao;
    private final InvInvoiceService invInvoiceService;

    @Override
    public PagingVO<AccReimTaxVO> queryPaging(AccReimTaxQuery query) {

        PagingVO<AccReimTaxVO> paging = dao.queryPaging(query);
        if (!ObjectUtils.isEmpty(paging.getRecords())) {
            Set<Long> reimDtlId = paging.getRecords().stream().map(AccReimTaxVO::getReimDtlId).collect(Collectors.toSet());
            //获取发票
            InvInvoiceQuery invoiceQuery = new InvInvoiceQuery();
            invoiceQuery.setReimDIdList(reimDtlId);
            List<InvInvoiceVO> invInvoiceVOS = invInvoiceService.queryListDynamic(invoiceQuery);
            Map<Long, List<InvInvoiceVO>> invInvoiceGroup = invInvoiceVOS.stream().collect(Collectors.groupingBy(InvInvoiceVO::getReimDId));
            paging.getRecords().forEach(
                    vo -> {
                        //获取关联发票
                        List<InvInvoiceVO> invDetails = invInvoiceGroup.get(vo.getReimDtlId());
                        if (!ObjectUtils.isEmpty(invDetails)) {
                            vo.setInvInvoiceList(invDetails);
                        }
                        //不含税金额
                        if(vo.getReimAmt()!=null){
                            BigDecimal taxAmt = ObjectUtils.isEmpty(vo.getTaxAmt()) ? BigDecimal.ZERO : vo.getTaxAmt();
                            BigDecimal noTaxReimAmt = vo.getReimAmt().subtract(taxAmt);
                            vo.setNoTaxReimAmt(noTaxReimAmt);
                        }
                    }
            );
        }
        return paging;
    }

    @Override
    public List<AccReimTaxVO> queryListDynamic(AccReimTaxQuery query) {
        List<AccReimTaxVO> accReimTaxVOS = dao.queryListDynamic(query);
        if (!ObjectUtils.isEmpty(accReimTaxVOS)) {
            Set<Long> reimDtlId = accReimTaxVOS.stream().map(AccReimTaxVO::getReimDtlId).collect(Collectors.toSet());
            //获取发票
            InvInvoiceQuery invoiceQuery = new InvInvoiceQuery();
            invoiceQuery.setReimDIdList(reimDtlId);
            List<InvInvoiceVO> invInvoiceVOS = invInvoiceService.queryListDynamic(invoiceQuery);
            Map<Long, List<InvInvoiceVO>> invInvoiceGroup = invInvoiceVOS.stream().collect(Collectors.groupingBy(InvInvoiceVO::getReimDId));
            accReimTaxVOS.forEach(
                    vo -> {
                        //获取关联发票
                        List<InvInvoiceVO> invDetails = invInvoiceGroup.get(vo.getReimDtlId());
                        if (!ObjectUtils.isEmpty(invDetails)) {
                            vo.setInvInvoiceList(invDetails);
                        }
                        //不含税金额
                        if(vo.getReimAmt()!=null){
                            BigDecimal taxAmt = ObjectUtils.isEmpty(vo.getTaxAmt()) ? BigDecimal.ZERO : vo.getTaxAmt();
                            BigDecimal noTaxReimAmt = vo.getReimAmt().subtract(taxAmt);
                            vo.setNoTaxReimAmt(noTaxReimAmt);
                        }
                    }
            );
        }
        return accReimTaxVOS;
    }

    @Override
    public AccReimTaxVO queryByKey(Long key) {
        return dao.queryByKey(key);
    }

    @Override
    @Transactional
    public AccReimTaxVO insert(AccReimTaxPayload payload) {
        AccReimTaxDO entityDo = AccReimTaxConvert.INSTANCE.toDo(payload);
        return AccReimTaxConvert.INSTANCE.toVo(repo.save(entityDo));
    }

    @Override
    @Transactional
    public long batchInsert(List<AccReimTaxPayload> payloadList) {
        List<AccReimTaxDO> dos = AccReimTaxConvert.INSTANCE.payloads2Dos(payloadList);
        List<AccReimTaxDO> saveDOs = dao.saveAll(dos);
        return saveDOs.size();
    }

    @Override
    @Transactional
    public AccReimTaxVO update(AccReimTaxPayload payload) {
        AccReimTaxQuery query = new AccReimTaxQuery();
        query.setId(payload.getId());
        long count = dao.count(query);
        if (count <= 0) {
            log.warn("当前id:[{}]对应记录不存在", payload.getId());
            return null;
        }
        AccReimTaxDO entity = AccReimTaxConvert.INSTANCE.toDo(payload);
        return AccReimTaxConvert.INSTANCE.toVo(repo.save(entity));
    }

    @Override
    @Transactional
    public long updateByKeyDynamic(AccReimTaxPayload payload) {
        AccReimTaxDO entity = repo.findById(payload.getId()).orElseGet(AccReimTaxDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = dao.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            dao.deleteSoft(keys);
        }
    }

    @Override
    @Transactional
    public void delByReimId(Long reimId) {
        dao.delByReimId(reimId);
    }

    @Override
    public List<AccReimExportVO> getExportTaxData(Set<Long> idList) {
        return dao.getExportTaxData(idList);
    }

}
