package com.elitesland.tw.tw5.server.prd.administration.dao;

import com.elitesland.tw.tw5.api.prd.administration.payload.CertificationLicensePayload;
import com.elitesland.tw.tw5.api.prd.administration.query.CertificationLicenseQuery;
import com.elitesland.tw.tw5.api.prd.administration.vo.CertificationLicenseVO;
import com.elitesland.tw.tw5.server.prd.administration.entity.CertificationLicenseDO;
import com.elitesland.tw.tw5.server.prd.administration.entity.QCertificationLicenseDO;
import com.elitesland.tw.tw5.server.prd.administration.repo.CertificationLicenseRepo;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 资质证照
 *
 * @author wangly
 * @date 2023-09-20
 */
@Repository
@RequiredArgsConstructor
public class CertificationLicenseDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final CertificationLicenseRepo repo;
    private final QCertificationLicenseDO qdo = QCertificationLicenseDO.certificationLicenseDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<CertificationLicenseVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(CertificationLicenseVO.class,
                qdo.id,
                qdo.remark,
                qdo.createUserId,
                qdo.creator,
                qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 证件类型 udc[COM:LICENSE_TYPE]
                qdo.licenseType,
                // 证照名称
                qdo.licenseName,
                // 时间类型 udc[COM:TIME_TYPE]
                qdo.timeType,
                // 有效日期起
                qdo.validDateStart,
                // 有效日期止
                qdo.validDateEnd,
                // 附件
                qdo.fileCode,
                // 证照来源
                qdo.licenseSource,
                // 证照描述
                qdo.licenseDesc,
                // 排序号
                qdo.sortNo,
                // 扩展字段1
                qdo.ext1,
                // 扩展字段2
                qdo.ext2,
                // 扩展字段3
                qdo.ext3,
                // 扩展字段4
                qdo.ext4,
                // 扩展字段5
                qdo.ext5
        )).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<CertificationLicenseVO> getJpaQueryWhere(CertificationLicenseQuery query) {
        JPAQuery<CertificationLicenseVO> jpaQuery = getJpaQuerySelect();
            // 条件封装
            jpaQuery.where(where(query));
            // 常用基础查询条件拼装
            SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
            // 动态排序
            jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
            return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(CertificationLicenseQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
        .select(qdo.count())
        .from(qdo);
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(CertificationLicenseQuery query){
        List<Predicate> list = new ArrayList<>();
        /** 记录唯一ID 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 证件类型 udc[COM:LICENSE_TYPE] 精确 */
        if (!ObjectUtils.isEmpty(query.getLicenseType())) {
            list.add(qdo.licenseType.eq(query.getLicenseType()));
        }
        /** 证照名称 精确 */
        if (!ObjectUtils.isEmpty(query.getLicenseName())) {
            list.add(qdo.licenseName.eq(query.getLicenseName()));
        }
        /** 时间类型 udc[COM:TIME_TYPE] 精确 */
        if (!ObjectUtils.isEmpty(query.getTimeType())) {
            list.add(qdo.timeType.eq(query.getTimeType()));
        }
        /** 有效日期起 精确 */
        if (!ObjectUtils.isEmpty(query.getValidDateStart())) {
            list.add(qdo.validDateStart.goe(query.getValidDateStart()));
        }
        /** 有效日期止 精确 */
        if (!ObjectUtils.isEmpty(query.getValidDateEnd())) {
            list.add(qdo.validDateEnd.loe(query.getValidDateEnd()));
        }
        /** 附件 精确 */
        if (!ObjectUtils.isEmpty(query.getFileCode())) {
            list.add(qdo.fileCode.eq(query.getFileCode()));
        }
        /** 证照来源 精确 */
        if (!ObjectUtils.isEmpty(query.getLicenseSource())) {
            list.add(qdo.licenseSource.eq(query.getLicenseSource()));
        }
        /** 证照描述 精确 */
        if (!ObjectUtils.isEmpty(query.getLicenseDesc())) {
            list.add(qdo.licenseDesc.eq(query.getLicenseDesc()));
        }
        /** 排序号 精确 */
        if (!ObjectUtils.isEmpty(query.getSortNo())) {
            list.add(qdo.sortNo.eq(query.getSortNo()));
        }
        /** 扩展字段1 精确 */
        if (!ObjectUtils.isEmpty(query.getExt1())) {
            list.add(qdo.ext1.eq(query.getExt1()));
        }
        /** 扩展字段2 精确 */
        if (!ObjectUtils.isEmpty(query.getExt2())) {
            list.add(qdo.ext2.eq(query.getExt2()));
        }
        /** 扩展字段3 精确 */
        if (!ObjectUtils.isEmpty(query.getExt3())) {
            list.add(qdo.ext3.eq(query.getExt3()));
        }
        /** 扩展字段4 精确 */
        if (!ObjectUtils.isEmpty(query.getExt4())) {
            list.add(qdo.ext4.eq(query.getExt4()));
        }
        /** 扩展字段5 精确 */
        if (!ObjectUtils.isEmpty(query.getExt5())) {
            list.add(qdo.ext5.eq(query.getExt5()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public CertificationLicenseVO queryByKey(Long id) {
        JPAQuery<CertificationLicenseVO> jpaQuery = getJpaQuerySelect();
            jpaQuery.where(qdo.id.eq(id));
            jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<CertificationLicenseVO> queryListDynamic(CertificationLicenseQuery query) {
        JPAQuery<CertificationLicenseVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<CertificationLicenseVO> queryPaging(CertificationLicenseQuery query) {
        long total = count(query);
        if (total == 0) {
             return PagingVO.empty();
        }
        JPAQuery<CertificationLicenseVO> jpaQuery = getJpaQueryWhere(query);
        List<CertificationLicenseVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<CertificationLicenseVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public CertificationLicenseDO save(CertificationLicenseDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<CertificationLicenseDO> saveAll(List<CertificationLicenseDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(CertificationLicensePayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
        .where(qdo.id.eq(payload.getId()));
        // 记录唯一ID
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 证件类型 udc[COM:LICENSE_TYPE]
        if (payload.getLicenseType() != null) {
            update.set(qdo.licenseType, payload.getLicenseType());
        }
        // 证照名称
        if (payload.getLicenseName() != null) {
            update.set(qdo.licenseName, payload.getLicenseName());
        }
        // 时间类型 udc[COM:TIME_TYPE]
        if (payload.getTimeType() != null) {
            update.set(qdo.timeType, payload.getTimeType());
        }
        // 有效日期起
        if (payload.getValidDateStart() != null) {
            update.set(qdo.validDateStart, payload.getValidDateStart());
        }
        // 有效日期止
        if (payload.getValidDateEnd() != null) {
            update.set(qdo.validDateEnd, payload.getValidDateEnd());
        }
        // 附件
        if (payload.getFileCode() != null) {
            update.set(qdo.fileCode, payload.getFileCode());
        }
        // 证照来源
        if (payload.getLicenseSource() != null) {
            update.set(qdo.licenseSource, payload.getLicenseSource());
        }
        // 证照描述
        if (payload.getLicenseDesc() != null) {
            update.set(qdo.licenseDesc, payload.getLicenseDesc());
        }
        // 排序号
        if (payload.getSortNo() != null) {
            update.set(qdo.sortNo, payload.getSortNo());
        }
        // 扩展字段1
        if (payload.getExt1() != null) {
            update.set(qdo.ext1, payload.getExt1());
        }
        // 扩展字段2
        if (payload.getExt2() != null) {
            update.set(qdo.ext2, payload.getExt2());
        }
        // 扩展字段3
        if (payload.getExt3() != null) {
            update.set(qdo.ext3, payload.getExt3());
        }
        // 扩展字段4
        if (payload.getExt4() != null) {
            update.set(qdo.ext4, payload.getExt4());
        }
        // 扩展字段5
        if (payload.getExt5() != null) {
            update.set(qdo.ext5, payload.getExt5());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 记录唯一ID
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 证件类型 udc[COM:LICENSE_TYPE]
            if (nullFields.contains("licenseType")) {
                update.setNull(qdo.licenseType);
            }
            // 证照名称
            if (nullFields.contains("licenseName")) {
                update.setNull(qdo.licenseName);
            }
            // 时间类型 udc[COM:TIME_TYPE]
            if (nullFields.contains("timeType")) {
                update.setNull(qdo.timeType);
            }
            // 有效日期起
            if (nullFields.contains("validDateStart")) {
                update.setNull(qdo.validDateStart);
            }
            // 有效日期止
            if (nullFields.contains("validDateEnd")) {
                update.setNull(qdo.validDateEnd);
            }
            // 附件
            if (nullFields.contains("fileCode")) {
                update.setNull(qdo.fileCode);
            }
            // 证照来源
            if (nullFields.contains("licenseSource")) {
                update.setNull(qdo.licenseSource);
            }
            // 证照描述
            if (nullFields.contains("licenseDesc")) {
                update.setNull(qdo.licenseDesc);
            }
            // 排序号
            if (nullFields.contains("sortNo")) {
                update.setNull(qdo.sortNo);
            }
            // 扩展字段1
            if (nullFields.contains("ext1")) {
                update.setNull(qdo.ext1);
            }
            // 扩展字段2
            if (nullFields.contains("ext2")) {
                update.setNull(qdo.ext2);
            }
            // 扩展字段3
            if (nullFields.contains("ext3")) {
                update.setNull(qdo.ext3);
            }
            // 扩展字段4
            if (nullFields.contains("ext4")) {
                update.setNull(qdo.ext4);
            }
            // 扩展字段5
            if (nullFields.contains("ext5")) {
                update.setNull(qdo.ext5);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
            .set(qdo.deleteFlag, 1)
            .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

}

