package com.elitesland.tw.tw5.server.prd.borrow.workflow;

import com.elitesland.tw.tw5.api.prd.borrow.payload.BorrowMoneyPayload;
import com.elitesland.tw.tw5.api.prd.borrow.service.BorrowMoneyService;
import com.elitesland.tw.tw5.api.prd.borrow.vo.BorrowMoneyVO;
import com.elitesland.tw.tw5.api.prd.my.payload.TMoneyTransferPayload;
import com.elitesland.tw.tw5.api.prd.my.vo.TMoneyTransferVO;
import com.elitesland.tw.tw5.server.common.workFlow.CommonWorkflowCallbackController;
import com.elitesland.tw.tw5.server.common.workFlow.ProcDefKey;
import com.elitesland.tw.tw5.server.prd.borrow.constant.BorrowStatusEnum;
import com.elitesland.tw.tw5.server.prd.my.constant.TransferStatusEnum;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;

@Slf4j
@Service(CommonWorkflowCallbackController.SERVICE_NAME_PREFIX + "BORROW_MONEY")
public class BorrowMoneyWorkflowCallBackController implements WorkflowCallBack {
    @Autowired
    private  BorrowMoneyService service;
    @Override
    public WorkflowResult<ArrayList<String>> taskAssignee(TaskAssigneePayload payload) {
        log.info("customer taskAssignee:{}", payload);
        return WorkflowResult.success(null);
    }

    @Override
    public WorkflowResult<Void> taskCreated(TaskCreatedPayload payload) {
        log.info("customer taskCreated:{}", payload);
        return WorkflowResult.success(null);
    }

    @Override
    public WorkflowResult<Void> taskCompleted(TaskCompletedPayload payload) {
        log.info("customer taskCompleted:{}", payload);
        return WorkflowResult.success(null);
    }

    @Override
    public WorkflowResult<Void> processStatusChange(ProcessStatusChangePayload payload) {
        log.info("customer processStatusChange:{}", payload);
        String businessKey = payload.getBusinessKey();
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        BorrowMoneyPayload borrowMoneyPayload = new BorrowMoneyPayload();
        borrowMoneyPayload.setId(Long.parseLong(businessKey));
        //根据业务key查询当前业务对象
        BorrowMoneyVO borrowMoneyVO = service.queryByKey(Long.valueOf(businessKey));
        if (borrowMoneyVO != null) {
            switch (procInstStatus) {
                case NOTSUBMIT://创建人提交节点
                    //一般情况将单据状态变成"新建",流程状态改为未提交
//                    busiCardApplyPayload.setDetailedStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                    borrowMoneyPayload.setProcInstStatus(ProcInstStatus.NOTSUBMIT);
                    borrowMoneyPayload.setApprStatus(BorrowStatusEnum.CREATE.getCode());
                    break;
                case INTERRUPT://中断（删除工作流，初始化单据，管理员操作）
                    //一般情况将单据状态变成"新建",并且将单据上的"流程实例状态"，"流程实例ID"清成null
//                    epibolyCostConDPayload.setDetailedStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                    borrowMoneyPayload.setNullFields(Arrays.asList("procInstStatus", "procInstId", "submitTime"));
                    break;
                case INVALID://先删除流程再删除单据
                    borrowMoneyPayload.setDeleteFlag(1);
                    borrowMoneyPayload.setProcInstStatus(ProcInstStatus.INVALID);
                    break;
                case REJECTED://审批人拒绝，回到第一个节点
                    //将单据状态变为新建状态
                    borrowMoneyPayload.setProcInstStatus(ProcInstStatus.REJECTED);
                    break;
                case APPROVED:
                    //一般情况将单据状态变成"激活"
                    borrowMoneyPayload.setProcInstStatus(ProcInstStatus.APPROVED);
                    borrowMoneyPayload.setApprovedTime(LocalDateTime.now());
                    borrowMoneyPayload.setApprStatus(BorrowStatusEnum.PAID.getCode());
                    break;
                case APPROVING:
                    borrowMoneyPayload.setProcInstStatus(ProcInstStatus.APPROVING);
                    borrowMoneyPayload.setApprStatus(BorrowStatusEnum.APPROVING.getCode());

            }
            service.updateByKeyDynamic(borrowMoneyPayload);
        }
        return WorkflowResult.success(null);
    }
}
