package com.elitesland.tw.tw5.server.prd.copartner.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.copartner.payload.PerformanceReadmeConfigPayload;
import com.elitesland.tw.tw5.api.prd.copartner.payload.PerformanceReadmeConfigUserPayload;
import com.elitesland.tw.tw5.api.prd.copartner.query.PerformanceReadmeConfigDetailQuery;
import com.elitesland.tw.tw5.api.prd.copartner.query.PerformanceReadmeConfigQuery;
import com.elitesland.tw.tw5.api.prd.copartner.query.PerformanceReadmeConfigUserQuery;
import com.elitesland.tw.tw5.api.prd.copartner.service.PerformanceReadmeConfigDetailService;
import com.elitesland.tw.tw5.api.prd.copartner.service.PerformanceReadmeConfigService;
import com.elitesland.tw.tw5.api.prd.copartner.service.PerformanceReadmeConfigUserService;
import com.elitesland.tw.tw5.api.prd.copartner.vo.PerformanceReadmeConfigDetailVO;
import com.elitesland.tw.tw5.api.prd.copartner.vo.PerformanceReadmeConfigUserVO;
import com.elitesland.tw.tw5.api.prd.copartner.vo.PerformanceReadmeConfigVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.copartner.convert.PerformanceReadmeConfigConvert;
import com.elitesland.tw.tw5.server.prd.copartner.convert.PerformanceReadmeConfigUserConvert;
import com.elitesland.tw.tw5.server.prd.copartner.dao.PerformanceReadmeConfigDAO;
import com.elitesland.tw.tw5.server.prd.copartner.entity.PerformanceReadmeConfigDO;
import com.elitesland.tw.tw5.server.prd.copartner.repo.PerformanceReadmeConfigRepo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 合伙人绩效自述配置
 *
 * @author carl
 * @date 2024-06-24
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PerformanceReadmeConfigServiceImpl extends BaseServiceImpl implements PerformanceReadmeConfigService {

    private final PerformanceReadmeConfigRepo performanceReadmeConfigRepo;
    private final PerformanceReadmeConfigDAO performanceReadmeConfigDAO;
    private final PerformanceReadmeConfigDetailService performanceReadmeConfigDetailService;
    private final PerformanceReadmeConfigUserService performanceReadmeConfigUserService;

    @Override
    public PagingVO<PerformanceReadmeConfigVO> queryPaging(PerformanceReadmeConfigQuery query) {
        return performanceReadmeConfigDAO.queryPaging(query);
    }

    @Override
    public List<PerformanceReadmeConfigVO> queryListDynamic(PerformanceReadmeConfigQuery query) {
        return performanceReadmeConfigDAO.queryListDynamic(query);
    }

    @Override
    public PerformanceReadmeConfigVO queryByKey(Long key) {
        PerformanceReadmeConfigVO performanceReadmeConfigVO = performanceReadmeConfigDAO.queryByKey(key);
        PerformanceReadmeConfigDetailQuery queryDetail = new PerformanceReadmeConfigDetailQuery();
        queryDetail.setConfigId(key);
        List<PerformanceReadmeConfigDetailVO> performanceReadmeConfigDetailVOS = performanceReadmeConfigDetailService.queryListDynamic(queryDetail);
        PerformanceReadmeConfigUserQuery queryUser = new PerformanceReadmeConfigUserQuery();
        queryUser.setConfigId(key);
        List<PerformanceReadmeConfigUserVO> performanceReadmeConfigUserVOS = performanceReadmeConfigUserService.queryListDynamic(queryUser);
        performanceReadmeConfigVO.setPerformanceReadmeConfigDetailVOs(performanceReadmeConfigDetailVOS);
        performanceReadmeConfigVO.setPerformanceReadmeConfigUserVO(performanceReadmeConfigUserVOS);
        return performanceReadmeConfigVO;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PerformanceReadmeConfigVO insertOrUpdate(PerformanceReadmeConfigPayload payload) {
        if (payload.getId() != null) {
            PerformanceReadmeConfigVO vo = performanceReadmeConfigDAO.queryByKey(payload.getId());
            if (vo != null && !"0".equals(vo.getConfigStatus())) {
                throw TwException.error("", "该状态不可编辑");
            }
            //删除配置详情
            performanceReadmeConfigDetailService.deleteSoftByConfigId(payload.getId());
            //删除配置用户
            performanceReadmeConfigUserService.deleteSoftByConfigId(payload.getId());
        }
        payload.setConfigStatus("0");
        PerformanceReadmeConfigDO entityDo = PerformanceReadmeConfigConvert.INSTANCE.toDo(payload);
        PerformanceReadmeConfigDO save = performanceReadmeConfigRepo.save(entityDo);
        payload.getPerformanceReadmeConfigDetailPayloads().forEach(detail -> detail.setConfigId(save.getId()));
        payload.getPerformanceReadmeConfigUserPayloads().forEach(user -> user.setConfigId(save.getId()));
        //批量新增配置详情
        performanceReadmeConfigDetailService.batchInsert(payload.getPerformanceReadmeConfigDetailPayloads());
        //批量新增配置用户
        performanceReadmeConfigUserService.batchInsert(payload.getPerformanceReadmeConfigUserPayloads());

        return PerformanceReadmeConfigConvert.INSTANCE.toVo(performanceReadmeConfigRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PerformanceReadmeConfigVO update(PerformanceReadmeConfigPayload payload) {
        PerformanceReadmeConfigDO entity = performanceReadmeConfigRepo.findById(payload.getId()).orElseGet(PerformanceReadmeConfigDO::new);
        Assert.notNull(entity.getId(), "不存在");
        PerformanceReadmeConfigDO entityDo = PerformanceReadmeConfigConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return PerformanceReadmeConfigConvert.INSTANCE.toVo(performanceReadmeConfigRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(PerformanceReadmeConfigPayload payload) {

        long result = performanceReadmeConfigDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            List<PerformanceReadmeConfigVO> performanceReadmeConfigVOS = performanceReadmeConfigDAO.queryByKeys(keys);
            long count = performanceReadmeConfigVOS.stream().filter(vo -> StringUtils.hasText(vo.getConfigStatus()) && !"0".equals(vo.getConfigStatus())).count();
            if (count > 0) {
                throw TwException.error("", "该状态不支持删除操作");
            }
            performanceReadmeConfigDAO.deleteSoft(keys);
        }
    }

    @Override
    public void startAssessment(Long key) {
        PerformanceReadmeConfigVO vo = performanceReadmeConfigDAO.queryByKey(key);
        if (vo == null || !"0".equals(vo.getConfigStatus())) {
            throw TwException.error("", "不可再次发起");
        }
        PerformanceReadmeConfigUserQuery query = new PerformanceReadmeConfigUserQuery();
        query.setConfigId(key);
        List<PerformanceReadmeConfigUserVO> performanceReadmeConfigUserVOS = performanceReadmeConfigUserService.queryListDynamic(query);
        if (ObjectUtils.isEmpty(performanceReadmeConfigUserVOS)) {
            throw TwException.error("", "考核范围未配置");
        }

        PerformanceReadmeConfigPayload payload = new PerformanceReadmeConfigPayload();
        payload.setId(key);
        payload.setConfigStatus("1");
        payload.setApplyUserId(GlobalUtil.getLoginUserId());
        payload.setApplyTime(LocalDateTime.now());
        performanceReadmeConfigDAO.updateByKeyDynamic(payload);

        performanceReadmeConfigUserVOS.forEach(userVO -> {
            PerformanceReadmeConfigUserPayload userPayload = PerformanceReadmeConfigUserConvert.INSTANCE.toPayload(userVO);
            userPayload.setConfigName(vo.getConfigName());
            userPayload.setInitFlag(false);
            performanceReadmeConfigUserService.procInstUpdate(userPayload);

        });

    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void processStatusChange(ProcessStatusChangePayload payload) {
        String businessKey = payload.getBusinessKey();
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        PerformanceReadmeConfigUserVO configUserVO = performanceReadmeConfigUserService.querySimpleByKey(Long.parseLong(businessKey));
        if (configUserVO != null) {
            PerformanceReadmeConfigUserPayload configUserPayload = new PerformanceReadmeConfigUserPayload();
            configUserPayload.setId(configUserVO.getId());
            configUserPayload.setProcInstStatus(procInstStatus.name());

            switch (procInstStatus) {
                case NOTSUBMIT://创建人提交节点
                    //一般情况将单据状态变成"新建",流程状态改为未提交
                    configUserPayload.setApplyStatus(0);
                    break;
                case INTERRUPT://中断（删除工作流，初始化单据，管理员操作）
                    //一般情况将单据状态变成"新建",并且将单据上的"流程实例状态"，"流程实例ID"清成null
                    configUserPayload.setApplyStatus(1);
                    break;
                case INVALID://先删除流程再删除单据
                    configUserPayload.setApplyStatus(1);
                    break;
                case REJECTED://审批人拒绝，回到第一个节点
                    //将单据状态变为新建状态
                    configUserPayload.setApplyStatus(0);
                    break;
                case APPROVED:
                    //一般情况将单据状态变成"激活"
                    configUserPayload.setApplyStatus(1);
                    break;
                case APPROVING:
                    configUserPayload.setApplyStatus(0);
                    break;

            }
            performanceReadmeConfigUserService.updateByKeyDynamic(configUserPayload);

            if (configUserPayload.getApplyStatus() != null && configUserPayload.getApplyStatus().intValue() == 1) {
                //检测合伙人绩效配置是否完成
                PerformanceReadmeConfigUserQuery query = new PerformanceReadmeConfigUserQuery();
                query.setConfigId(configUserVO.getConfigId());
                List<PerformanceReadmeConfigUserVO> configUserVOS = performanceReadmeConfigUserService.queryListDynamic(query);

                List<PerformanceReadmeConfigUserVO> collect = configUserVOS.stream().filter(vo ->
                        (vo.getApplyStatus() == null || vo.getApplyStatus().intValue() == 0) &&
                                vo.getId().longValue() != configUserVO.getId().longValue()
                ).collect(Collectors.toList());
                if (ObjectUtils.isEmpty(collect)) {
                    //伙人绩效配置完成
                    PerformanceReadmeConfigPayload configPayload = new PerformanceReadmeConfigPayload();
                    configPayload.setId(configUserVO.getConfigId());
                    configPayload.setConfigStatus("2");
                    configPayload.setFinishTime(LocalDateTime.now());
                    long result = performanceReadmeConfigDAO.updateByKeyDynamic(configPayload);
                }
            }


        }

    }

}
