package com.elitesland.tw.tw5.server.prd.crm.controller;

import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOperationPlanDetailPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOperationPlanDetailQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmCustomerOperationService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOperationPlanDetailMemberService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOperationPlanDetailService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOperationPlanDetailVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdCommentService;
import com.elitesland.tw.tw5.api.prd.system.service.PrdFsmFileRefService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemLogVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.system.constant.PrdCommentObjTypeEnum;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRoleDAO;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 客户经营-经营计划明细
 *
 * @author duwh
 * @date 2022/11/17
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm")
@Slf4j
public class CrmOperationPlanDetailController {

    private final CrmOperationPlanDetailService service;
    private final CrmCustomerOperationService crmCustomerOperationService;
    private final CrmOperationPlanDetailMemberService memberService;
    private final PrdCommentService prdCommentService;
    private final PrdFsmFileRefService prdFsmFileRefService;
    private final PrdSystemRoleDAO systemRoleDAO;


    /**
     * 新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping("/operationPlanDetail")
    public TwOutputUtil insert(@RequestBody CrmOperationPlanDetailPayload payload) {
        return TwOutputUtil.ok(service.insert(payload));
    }


    /**
     * 更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("/operationPlanDetail")
    public TwOutputUtil update(CrmOperationPlanDetailPayload payload) {
        return TwOutputUtil.ok(service.update(payload));
    }

    /**
     * 主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/operationPlanDetail/{key}")
    @UdcNameClass
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        CrmOperationPlanDetailVO prdFileVO = service.queryByKey(key);
        return TwOutputUtil.ok(prdFileVO);
    }

    /**
     * 操作记录日志列表
     *
     * @param key 客户经营主键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/operationPlanDetail/log/list/{key}")
    public TwOutputUtil logList(@PathVariable Long key) {
        final List<PrdSystemLogVO> prdSystemLogVOS = service.queryLogList(key);
        return TwOutputUtil.ok(prdSystemLogVOS);
    }

    /**
     * 分页 有数据权限
     *
     * 1、拥有角色 【系统管理员】、【客户经营管理员】 不校验权限；
     * 2、 经营计划参与者 or 经营计划 执行者  or 经营计划创建人
     *
     * or 关联客户经营中的人员信息 （  客户经营创建人 or  销售经营部负责人 or 客户经营部负责人 or 渠道经营负责人 or 产品负责人 or 服务负责人 or 商务负责人 or 关怀负责人 or 运维售后负责人
     *
     * or 存在上下级情况 （我的下级是服务负责人 or  我的下级是商务负责人 or 我的下级是关怀负责人 or 我的下级是运维售后负责人 ）
     *
     * or 组织负责人视角（ 我负责的组织是客户经营部门  or  我负责的组织是销售经营部门）   ）
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/operationPlanDetail/paging")
    @UdcNameClass
    public TwOutputUtil paging(CrmOperationPlanDetailQuery query) {
        final Long loginUserId = GlobalUtil.getLoginUserId();
        // 判断 管理员
        final boolean isSystemAdmin = GlobalUtil.getLoginGeneralUser().isSystemAdmin();
        PagingVO<CrmOperationPlanDetailVO> paging;
        if (isSystemAdmin) {
            query.setManagerFlag(true);
            paging = service.pagingDataFilter(query);
            //paging = service.paging(query);
        } else {
            // 判断当前登录人是否是系统管理员or 拥有角色【客户经营管理员	CUST_OPER_MANAGER】
            List<Long> userIdsByRole = systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.CUST_OPER_MANAGER.getCode()));
            if (!CollectionUtils.isEmpty(userIdsByRole) && userIdsByRole.contains(loginUserId)) {
                query.setManagerFlag(true);
                paging = service.pagingDataFilter(query);
                //paging = service.paging(query);
            } else {
                // 数据权限 创建人 、经营计划参与者、经营计划执行者
                paging = service.pagingDataFilter(query);
            }
        }
        final List<CrmOperationPlanDetailVO> records = paging.getRecords();
        if (!CollectionUtils.isEmpty(records)) {
            records.forEach(vo -> {
                // 通过关联方式查询实现，不用下面的方式
                // 经营计划 客户名称翻译
                //final CrmCustomerOperationVO operationVO = crmCustomerOperationService.queryByKey(vo.getOperId());
                //vo.setCustName(null != operationVO ? operationVO.getCustName() : "");

                // 获取经营计划参与者
                //CrmOperationPlanDetailMemberQuery memberQuery = new CrmOperationPlanDetailMemberQuery();
                //memberQuery.setPlanDetailId(vo.getId());
                //final PagingVO<CrmOperationPlanDetailMemberVO> memberVOPagingVO = memberService.paging(memberQuery);
                //final List<CrmOperationPlanDetailMemberVO> memberVOList = memberVOPagingVO.getRecords();
                //vo.setMemberList(memberVOList);

                // 统计评论个数
                vo.setComments(prdCommentService.count(PrdCommentObjTypeEnum.OPER_PLAN.getCode(), vo.getId()));
                // 统计附件个数
                vo.setFiles(prdFsmFileRefService.count(PrdCommentObjTypeEnum.OPER_PLAN.getCode(), vo.getId()));

            });
        }
        return TwOutputUtil.ok(paging);
    }

    /**
     * 查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/operationPlanDetail/list")
    @UdcNameClass
    public TwOutputUtil queryList(CrmOperationPlanDetailQuery query) {
        List<CrmOperationPlanDetailVO> vos = service.queryList(query);
        return TwOutputUtil.ok(vos);
    }

    /**
     * 工时选择经营计划列表
     *
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/operationPlanDetail/listForTimeSheet")
    @UdcNameClass
    public TwOutputUtil listForTimeSheet() {
        List<CrmOperationPlanDetailVO> vos = service.listForTimeSheet();
        return TwOutputUtil.ok(vos);
    }

    /**
     * 删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/operationPlanDetail/deleteSoft")
    public TwOutputUtil deleteSoft(Long[] keys) {
        service.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }


}
