package com.elitesland.tw.tw5.server.prd.crm.controller;

import cn.zhxu.bs.BeanSearcher;
import cn.zhxu.bs.FieldOps;
import cn.zhxu.bs.util.MapBuilder;
import cn.zhxu.bs.util.MapUtils;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmFollowPayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOpportunityPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOpportunityQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityListVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityVO;
import com.elitesland.tw.tw5.api.prd.prj.vo.PrjProjectMemberVO;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemLogQuery;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.common.permission.annotation.FunctionDetail;
import com.elitesland.tw.tw5.server.common.permission.annotation.PermissionDomain;
import com.elitesland.tw.tw5.server.common.permission.annotation.PermissionFunction;
import com.elitesland.tw.tw5.server.common.permission.enums.FunctionCodeEnum;
import com.elitesland.tw.tw5.server.common.permission.enums.FunctionTypeEnum;
import com.elitesland.tw.tw5.server.common.permission.enums.PermissionDomainEnum;
import com.elitesland.tw.tw5.server.common.permission.enums.PermissionTypeEnum;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 商机管理
 *
 * @author carl.wang
 * @date
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm")
@Slf4j
@PermissionDomain(domain = PermissionDomainEnum.BUSINESS_OPPORTUNITY)
public class CrmOpportunityController {

    private final CrmOpportunityService service;

    private final BeanSearcher beanSearcher;

    /**
     * 新建
     *
     * @param payload po类
     * @return result
     */
    @PostMapping("/oppo/insert")
    public TwOutputUtil insert(CrmOpportunityPayload payload) {
        CrmOpportunityVO vo = service.insert(payload);
        return TwOutputUtil.ok(vo);
    }

    /**
     * 修改
     *
     * @param payload po类
     * @return result
     */
    @PutMapping("/oppo/update")
    public TwOutputUtil update(CrmOpportunityPayload payload) {
        if (payload.getOppoIdV4() != null) {
            payload.setId(service.getIdByV4(payload.getOppoIdV4()));
        }
        service.update(payload);
        return TwOutputUtil.ok();
    }

    /**
     * 修改
     *
     * @param payload po类
     * @return result
     */
    @PostMapping("/oppo/updateFromV4")
    public TwOutputUtil updateFromV4(CrmOpportunityPayload payload) {
        if (payload.getOppoIdV4() != null) {
            payload.setId(service.getIdByV4(payload.getOppoIdV4()));
        }
        service.update(payload);
        return TwOutputUtil.ok();
    }

    /**
     * 切换验证状态接口（待验证改为已验证，已验证改为待验证）
     *
     * @param ids
     * @return
     */
    @PostMapping("/oppo/toggleCheckStatus")
//    @PermissionFunction(functions = {
//            @FunctionDetail(functionCode = FunctionCodeEnum.BUSINESS_CAHNGE_CHECK_STATUS, type = FunctionTypeEnum.BUTTON)
//    })
    public TwOutputUtil toggleCheckStatus(@RequestBody List<Long> ids) {
        service.toggleCheckStatus(ids);
        return TwOutputUtil.ok();
    }
//    /**
//     * 分页查询
//     *
//     * @param query 查询条件
//     * @return result
//     */
//    @PostMapping("/oppo/paging")
//    @UdcNameClass
//    public TwOutputUtil paging(@RequestBody CrmOpportunityQuery query) {
//        return TwOutputUtil.ok(service.paging(query));
//    }

    /**
     * 分页查询
     *
     * @param query 查询条件
     * @return result
     */
    @GetMapping("/oppo/pagingPro")
    @UdcNameClass
    public TwOutputUtil pagingPro(CrmOpportunityQuery query) {
        return TwOutputUtil.ok(service.paging(query));
    }

    /**
     * 详情查询
     *
     * @param id 主键
     * @return result
     */
    @GetMapping("/oppo/queryByKey/{id}")
    @UdcNameClass
    @PermissionFunction(functions = {
            @FunctionDetail(functionCode = FunctionCodeEnum.BUSINESS_DETAIL, type = FunctionTypeEnum.BUTTON)
    }, fieldPermission = true)
    public TwOutputUtil<CrmOpportunityVO> queryByKey(@PathVariable Long id) {
        CrmOpportunityVO vo = service.queryByKey(id);
        return TwOutputUtil.ok(vo);
    }

    /**
     * 修改状态
     *
     * @param id 主键
     * @return result
     **/
    @GetMapping("/oppo/changeStatus/{id}")
//    @PermissionFunction(functions = {
//            @FunctionDetail(functionCode = FunctionCodeEnum.BUSINESS_CHANGE_STATUS, type = FunctionTypeEnum.BUTTON),
//            @FunctionDetail(functionCode = FunctionCodeEnum.BUSINESS_DETAIL_CHANGE_STATUS, type = FunctionTypeEnum.BUTTON),
//            @FunctionDetail(functionCode = FunctionCodeEnum.BUSINESS_ACTIVE, type = FunctionTypeEnum.BUTTON),
//            @FunctionDetail(functionCode = FunctionCodeEnum.BUSINESS_REOPEN, type = FunctionTypeEnum.BUTTON)
//    })
    public TwOutputUtil changeStatus(@PathVariable Long id, Long oppoIdV4) {
        if (oppoIdV4 != null) {
            id = service.getIdByV4(oppoIdV4);
        }
        service.changeStatus(id);
        return TwOutputUtil.ok();
    }

    /**
     * 关闭
     *
     * @param key         主键
     * @param closeReason 关闭原因
     * @param loseReson   丢单原因
     * @param clsoeRemark 关闭备注
     * @return result
     **/
    @GetMapping("/oppo/closeOpportunity")
//    @PermissionFunction(functions = {
//            @FunctionDetail(functionCode = FunctionCodeEnum.BUSINESS_CLOSE, type = FunctionTypeEnum.BUTTON)
//    })
    public TwOutputUtil closeOpportunity(Long key, String closeReason, String loseReson, String clsoeRemark, Long oppoIdV4) {
        if (oppoIdV4 != null) {
            key = service.getIdByV4(oppoIdV4);
        }
        service.closeOpportunity(key, closeReason, loseReson, clsoeRemark, true);
        return TwOutputUtil.ok();
    }

    /**
     * 添加成员
     *
     * @param oppoId  商机Id
     * @param userIds 添加成员userid
     * @return result
     */
    @GetMapping("/oppo/addMember")
    public TwOutputUtil addMember(Long oppoId, Long[] userIds) {
        List<PrjProjectMemberVO> memberVOS = service.addMember(oppoId, Arrays.asList(userIds));
        return TwOutputUtil.ok(memberVOS);
    }

    /**
     * 删除成员
     *
     * @param oppoId 商机Id
     * @param keys   成员主键id
     * @return result
     */
    @DeleteMapping("/oppo/deleteMember")
    public TwOutputUtil deleteMember(Long oppoId, Long[] keys) {
        service.deleteMember(oppoId, Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    /**
     * 添加跟进动态
     *
     * @param payload po类
     * @return result
     */
    @PostMapping("/oppo/addFollow")
    public TwOutputUtil addFollow(CrmFollowPayload payload) {
        service.addFollow(payload);
        return TwOutputUtil.ok();
    }

    /**
     * 修改跟进动态
     *
     * @param payload po类
     * @return result
     */
    @PutMapping("/oppo/updateFollow")
    public TwOutputUtil updateFollow(CrmFollowPayload payload) {
        service.updateFollow(payload);
        return TwOutputUtil.ok();
    }

    /**
     * 跟进动态列表查询
     *
     * @param objectId 商机Id
     * @return result
     */
    @GetMapping("/oppo/queryListFollow")
    public TwOutputUtil queryListFollow(Long objectId) {
        return TwOutputUtil.ok(service.queryListFollow(objectId));
    }

    /**
     * 查询修改记录
     *
     * @return result
     */
    @GetMapping("/oppo/queryLogList")
//    @PermissionFunction(functions = {
//            @FunctionDetail(functionCode = FunctionCodeEnum.BUSINESS_OPER_LOG, type = FunctionTypeEnum.TAB)
//    })
    public TwOutputUtil queryLogList(PrdSystemLogQuery query) {
        return TwOutputUtil.ok(service.queryLogList(query));
    }


    /**
     * 批量导出excel
     *
     * @return result
     */
    @ApiOperation("批量导出excel")
    @GetMapping("/oppo/batchExport")
//    @PermissionFunction(functions = {
//            @FunctionDetail(functionCode = FunctionCodeEnum.BUSINESS_EXPORT, type = FunctionTypeEnum.BUTTON)
//    })
    public void batchExport(HttpServletResponse response, CrmOpportunityQuery query) throws IOException {
        service.downloadBatch(response, query);
    }

    /**
     * 批量导出excel
     *
     * @return result
     */
    @ApiOperation("批量导出excel")
    @PostMapping("/oppo/permission/batchExport")
    public void permissionBatchExport(HttpServletResponse response, @RequestBody CrmOpportunityQuery query) throws IOException {
        service.permissionBatchExport(response, query);
    }

    /**
     * 关联客户
     *
     * @return result
     */
    @GetMapping("/oppo/bindCustomer/{id}")
    public TwOutputUtil bindCustomer(@PathVariable Long id) {
        Map<String, Object> result = new HashMap<>();
        try {
            result = service.bindCustomer(id);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            service.deleteSoft(id);
            return TwOutputUtil.error("", "绑定失败，请重试！", "");
        }
        return TwOutputUtil.ok(result);
    }


    /**
     * 对商机历史数据绑定客户
     */
    @GetMapping("/oppo/bindCustomers")
    public TwOutputUtil bindCustomers() {
        return TwOutputUtil.ok(service.bindCustomers());
    }


//     /**
//      * 获取易稻壳文件夹地址
//      * 1、文件夹不存在，创建、授权、返回itemId 存到商机数据中；获取易稻壳链接；
//      * 2、itemId存在，根据itemId查询易稻壳链接返回；
//      *
//      * @return result
//      */
//     @GetMapping("/oppo/yeedoc/getUri/{id}")
// //    @PermissionFunction(functions = {
// //            @FunctionDetail(functionCode = FunctionCodeEnum.BUSINESS_DOCUMENT_IMPORT, type = FunctionTypeEnum.BUTTON),
// //            @FunctionDetail(functionCode = FunctionCodeEnum.BUSINESS_DETAIL_DOCUMENT_IMPORT, type = FunctionTypeEnum.BUTTON)
// //    })
//     public TwOutputUtil yeedocGetUri(@PathVariable Long id) {
//         return TwOutputUtil.ok(service.yeedocGetUri(id));
//     }

    /**
     * 查询列表
     *
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/oppo/list")
    @UdcNameClass
    @ApiOperation("查询列表")
    public TwOutputUtil<List<CrmOpportunityListVO>> queryListDynamic(CrmOpportunityQuery query) {
        return TwOutputUtil.ok(service.queryListDynamic(query));
    }

    //    @PostMapping("/oppo/permission/paging")
    @PostMapping("/oppo/paging")
    @UdcNameClass
    @PermissionFunction(functions = {
            @FunctionDetail(functionCode = FunctionCodeEnum.BUSINESS_PAGE, type = FunctionTypeEnum.TAB)
    }, fieldPermission = true, permissionType = PermissionTypeEnum.DATA_PERMISSION)
    public TwOutputUtil<PagingVO<CrmOpportunityVO>> permissionPaging(@RequestBody CrmOpportunityQuery query) {

        return TwOutputUtil.ok(service.permissionPaging(query));
    }


    @PostMapping("/oppo/pagingOld")
    @UdcNameClass
    @ApiOperation("查询列表")
    public TwOutputUtil<PagingVO<CrmOpportunityVO>> pagingOld(@RequestBody CrmOpportunityQuery query) {

        return TwOutputUtil.ok(service.paging(query));
    }


    @PostMapping("/oppo/test")
    @UdcNameClass
    public TwOutputUtil<PagingVO<CrmOpportunityVO>> permissionTest(@RequestBody CrmOpportunityQuery query) {

        MapBuilder mapBuilder = MapUtils.builder().group("A")
                .field("id", 1).op(FieldOps.Equal)
                .group("B")
                .field("projectId2", 2).op(FieldOps.Equal)
                .groupExpr("A|B");

        beanSearcher.search(CrmOpportunityVO.class, mapBuilder.build());

        return TwOutputUtil.ok();
    }

    /**
     * 查询当前用户所在签约BU商机
     *
     * @return 商机列表
     */
    @GetMapping("/selectOpportunityListByUserBu")
    @UdcNameClass()
    public TwOutputUtil<List<CrmOpportunityVO>> selectOpportunityListByUserBu() {
        return TwOutputUtil.ok(service.selectOpportunityListByUserBu());
    }


    /**
     * 计算商机成单概率
     *
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/oppo/caculateProbability/{key}")
    @ApiOperation("计算商机成单概率")
    public TwOutputUtil caculateProbability(@PathVariable Long key) {
        return TwOutputUtil.ok(service.caculateProbability(key));
    }

}
