package com.elitesland.tw.tw5.server.prd.crm.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOpportunityMilestonePlanPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOpportunityMilestonePlanQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityMilestonePlanService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityMilestonePlanVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 里程碑计划
 *
 * @author zoey
 * @date 2023-11-01
 */
@Api(tags = "里程碑计划")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/crmOpportunityMilestonePlan")
@Slf4j
public class CrmOpportunityMilestonePlanController {

    private final CrmOpportunityMilestonePlanService crmOpportunityMilestonePlanService;
    private final CrmOpportunityService opportunityService;

    /**
     * 里程碑计划-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("里程碑计划-新增")
    public TwOutputUtil<CrmOpportunityMilestonePlanVO> insert(@RequestBody CrmOpportunityMilestonePlanPayload payload){
        CrmOpportunityMilestonePlanVO insert = crmOpportunityMilestonePlanService.insert(payload);
        Boolean aBoolean = opportunityService.checkIntegrity(payload.getOppoId());
        return TwOutputUtil.ok(insert);
    }

    /**
     * 里程碑计划-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("里程碑计划-更新")
    public TwOutputUtil<CrmOpportunityMilestonePlanVO> update(@RequestBody CrmOpportunityMilestonePlanPayload payload){
        CrmOpportunityMilestonePlanVO update = crmOpportunityMilestonePlanService.update(payload);
        Boolean aBoolean = opportunityService.checkIntegrity(payload.getOppoId());
        return TwOutputUtil.ok(update);
    }

    /**
     * 里程碑计划-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("里程碑计划-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody CrmOpportunityMilestonePlanPayload payload){
        return TwOutputUtil.ok(crmOpportunityMilestonePlanService.updateByKeyDynamic(payload));
    }

    /**
     * 里程碑计划-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("里程碑计划-主键查询")
    public TwOutputUtil<CrmOpportunityMilestonePlanVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(crmOpportunityMilestonePlanService.queryByKey(key));
    }

    /**
     * 里程碑计划-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("里程碑计划-分页")
    public TwOutputUtil<PagingVO<CrmOpportunityMilestonePlanVO>> paging(CrmOpportunityMilestonePlanQuery query) {
        return TwOutputUtil.ok(crmOpportunityMilestonePlanService.queryPaging(query));
    }

    /**
     * 里程碑计划-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    @UdcNameClass
    @ApiOperation("里程碑计划-查询列表")
    public TwOutputUtil<List<CrmOpportunityMilestonePlanVO>> queryList(CrmOpportunityMilestonePlanQuery query) {
        return TwOutputUtil.ok(crmOpportunityMilestonePlanService.queryListDynamic(query));
    }

    /**
     * 里程碑计划-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("里程碑计划-删除")
    public TwOutputUtil deleteSoft(Long oppoId,Long[] keys) {
        crmOpportunityMilestonePlanService.deleteSoft(Arrays.asList(keys));
        opportunityService.checkIntegrity(oppoId);
        return TwOutputUtil.ok();
    }

    /**
     * 里程碑计划-发布计划
     *
     * @param id 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/publish/{id}")
    // @UdcNameClass
    @ApiOperation("里程碑计划-发布计划")
    public TwOutputUtil publish(@PathVariable Long id) {
        crmOpportunityMilestonePlanService.publish(id);
        return TwOutputUtil.ok();
    }

}
