package com.elitesland.tw.tw5.server.prd.crm.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serial;

/**
 * 客户经营-经营计划模板
 *
 * @author duwh
 * @date 2022/11/15
 */
@Entity
@Table(name = "crm_customer_operation_plan_temp", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "crm_customer_operation_plan_temp", comment = "客户经营-经营计划模板")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class CrmOperationPlanTempDO extends BaseModel {

    @Serial
    private static final long serialVersionUID = -3773445665307666404L;

    @Comment("名称")
    @Column()
    private String name;

    @Comment("类型 udc[crm:cust_oper:type]")
    @Column()
    private String custType;

    /**
     * 类型、客户级别 确定唯一
     *
     * 特例：类型为 政府、组织及协会、生态伙伴的时候  客户级别为99 默认展示一级
     */
    @Comment("客户级别 udc[crm:cust_oper:cust_grade]")
    @Column()
    private String custGrade;

    @Comment("拓展1")
    @Column()
    private String ext1;

    @Comment("拓展2")
    @Column()
    private String ext2;

    @Comment("拓展3")
    @Column()
    private String ext3;

    @Comment("拓展4")
    @Column()
    private String ext4;

    @Comment("拓展5")
    @Column()
    private String ext5;


    public CrmOperationPlanTempDO() {
    }

    public void copy(CrmOperationPlanTempDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }

}
