package com.elitesland.tw.tw5.server.prd.crm.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.time.LocalDate;

/**
 * @Author carl.wang
 * @Description 市场计划表
 * @Date
 **/
@Entity
@Table(name = "crm_opportunity_analyze", indexes = {
        @Index(name = "oppo_index", columnList = "oppo_id"),
        @Index(name = "manage_index", columnList = "manage_user_id"),
})
@org.hibernate.annotations.Table(appliesTo = "crm_opportunity_analyze", comment = "商机案情分析表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class CrmOpportunityAnalyzeDO extends BaseModel {

    @Comment("商机ID")
    @Column(name = "oppo_id", nullable = false)
    private Long oppoId;

    @Comment("tw4.0商机案情分析ID")
    @Column(name = "analyze_id_v4")
    private Long analyzeIdV4;

    @Comment("负责人ID")
    @Column(name = "manage_user_id", nullable = false)
    private Long manageUserId;

    @Comment("具体行动")
    @Column()
    private String actionDesc;

    @Comment("核心关注点")
    @Column()
    private String concernDesc;

    @Comment("竞争优势")
    @Column()
    private String advantage;

    @Comment("对策")
    @Column()
    private String treatment;

    @Comment("案情日期")
    @Column()
    private LocalDate analyzeDate;

}
