package com.elitesland.tw.tw5.server.prd.crm.visit.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * 销售拜访计划成员
 *
 * @author liwenpeng
 * @date 2023-03-14
 */
@Entity
@Table(name = "crm_visit_plan_detail", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "crm_visit_plan_detail", comment = "销售拜访计划成员")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class VisitPlanDetailDO extends BaseModel implements Serializable  {
    /** 拜访计划id */
    @Comment("拜访计划id")
    @Column()
    private Long visitPlanId;
    /** 拜访人员id */
    @Comment("拜访人员id")
    @Column()
    private Long visitPersonId;
    /** 拜访成员类型，0：拜访成员，1：协访成员 */
    @Comment("拜访成员类型，0：拜访成员，1：协访成员")
    @Column()
    private String visitPersonType;
    /** extString1 */
    @Comment("extString1")
    @Column()
    private String extString1;

    public void copy(VisitPlanDetailDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
