package com.elitesland.tw.tw5.server.prd.file.service;

import com.elitesland.tw.tw5.api.prd.file.query.PrdFileVersionQuery;
import com.elitesland.tw.tw5.api.prd.file.vo.PrdFileRefVO;
import com.elitesland.tw.tw5.api.prd.file.vo.PrdFileVersionVO;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.prd.file.convert.PrdFileVersionConvert;
import com.elitesland.tw.tw5.server.prd.file.entity.PrdFileVersionDO;
import com.elitesland.tw.tw5.server.prd.file.repo.PrdFileVersionRepo;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.List;
import java.util.Optional;

/**
 * prd文件版本服务
 *
 * @author duwh
 * @date 2022/09/27
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PrdFileVersionServiceImpl implements PrdFileVersionService{

    private final PrdFileVersionRepo prdFileRefRepo;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PrdFileVersionDO insert(PrdFileVersionDO entity) {
        prdFileRefRepo.save(entity);
        return entity;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PrdFileVersionDO update(PrdFileVersionDO entity) {
        prdFileRefRepo.save(entity);
        return entity;
    }

    @Override
    public PrdFileVersionDO queryByKey(Long key) {
        PrdFileVersionDO entity = prdFileRefRepo.findById(key).orElseGet(PrdFileVersionDO::new);
        Assert.notNull(entity.getId(), "附件不存在");
        return entity;
    }

    @Override
    public List<PrdFileVersionVO> queryList(PrdFileVersionQuery query) {
        return PrdFileVersionConvert.INSTANCE.toVoList(prdFileRefRepo.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder)));
    }

    @Override
    public PagingVO<PrdFileRefVO> paging(PrdFileVersionQuery query) {
        Page<PrdFileVersionDO> page = prdFileRefRepo.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder), query.getPageRequest());
        return PageUtil.toPageVo(page.map(PrdFileVersionConvert.INSTANCE::toVo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            prdFileRefRepo.deleteSoft(keys);
        }
    }
}
