package com.elitesland.tw.tw5.server.prd.humanresources.ability.entity;

import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import lombok.Data;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import org.hibernate.annotations.Where;
import com.elitescloud.boot.model.entity.BaseModel;


/**
 * @author : WWW
 * @date : 2023-10-18
 * @desc : 级别维护明细表
 */

@Entity
@Table(name="prd_level_config_dtl")
@org.hibernate.annotations.Table(appliesTo = "prd_level_config_dtl", comment = "级别维护明细表")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0")
public class PrdLevelConfigDtlDO extends BaseModel {


    /**
     * 关联id
     */
    @Column(name = "mas_id", columnDefinition = "bigint(20) comment '关联id'")
    private Long masId;

    /**
     * 编号
     */
    @Column(name = "doc_no", columnDefinition = "varchar(255) comment '编号'")
    private String docNo;

    /**
     * 名称
     */
    @Column(name = "name", columnDefinition = "varchar(255) comment '名称'")
    private String name;

    /**
     * 序号
     */
    @Column(name = "sort", columnDefinition = "int(11) comment '序号'")
    private Integer sort;
}

