package com.elitesland.tw.tw5.server.prd.humanresources.examination.dao;

import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdPerformanceExamRelatePayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdPerformanceExamRelateQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdPerformanceExamRelateVO;
import com.elitesland.tw.tw5.server.prd.humanresources.examination.entity.PrdPerformanceExamRelateDO;
import com.elitesland.tw.tw5.server.prd.humanresources.examination.entity.QPrdPerformanceExamRelateDO;
import com.querydsl.jpa.impl.JPAUpdateClause;
import org.springframework.stereotype.Component;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.querydsl.core.types.Predicate;
import org.apache.commons.lang3.StringUtils;
import com.elitescloud.cloudt.common.base.PagingVO;
import java.util.List;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.List;
import com.querydsl.core.types.ExpressionUtils;
import java.util.ArrayList;


 /**
 * @author : WWW
 * @date : 2023-11-14
 * @desc : 可查看考核相关人员RepoProc
 */
 
@Component
public class PrdPerformanceExamRelateDao extends BaseRepoProc<PrdPerformanceExamRelateDO>{
    
    private static final QPrdPerformanceExamRelateDO qPrdPerformanceExamRelateDO = QPrdPerformanceExamRelateDO.prdPerformanceExamRelateDO;
    
    
    protected PrdPerformanceExamRelateDao() {
    
        super(qPrdPerformanceExamRelateDO);
        
    }
    
    
    public PagingVO<PrdPerformanceExamRelateVO> page(PrdPerformanceExamRelateQuery prdPerformanceExamRelateQuery) {
        
        JPAQuery<PrdPerformanceExamRelateVO> query = 
            select(PrdPerformanceExamRelateVO.class)
                .where(bulidPredicate(prdPerformanceExamRelateQuery));
        prdPerformanceExamRelateQuery.setPaging(query);
        prdPerformanceExamRelateQuery.fillOrders(query, qPrdPerformanceExamRelateDO);
        return PagingVO.<PrdPerformanceExamRelateVO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
                
    }
    
    
    public Long del(List<Long> ids) {
        
        Long res = jpaQueryFactory.update(qPrdPerformanceExamRelateDO)
                .set(qPrdPerformanceExamRelateDO.deleteFlag, 1)
                .where(qPrdPerformanceExamRelateDO.id.in(ids))
                .execute();
        
        return res;
        
    }
    
    
    public PrdPerformanceExamRelateVO get(Long id) {
    
        PrdPerformanceExamRelateVO prdPerformanceExamRelateVO = select(PrdPerformanceExamRelateVO.class)
                .where(qPrdPerformanceExamRelateDO.id.eq(id))
                .fetchOne();
        
        return prdPerformanceExamRelateVO;
        
    }
    
    
    public List<PrdPerformanceExamRelateVO> getList(PrdPerformanceExamRelateQuery prdPerformanceExamRelateQuery) {
        
        List<PrdPerformanceExamRelateVO> res = 
            select(PrdPerformanceExamRelateVO.class)
                .where(bulidPredicate(prdPerformanceExamRelateQuery))
                .fetch();
        
        return res;
        
    }
    
    
    private <T> JPAQuery<T> select(Class<T> cls) {
    
        return 
                jpaQueryFactory.select(Projections.bean(cls,
                    qPrdPerformanceExamRelateDO.examId,
                    qPrdPerformanceExamRelateDO.roleType,
                    qPrdPerformanceExamRelateDO.userId,
                    qPrdPerformanceExamRelateDO.resId,
                    qPrdPerformanceExamRelateDO.id,
                    qPrdPerformanceExamRelateDO.createTime,
                    qPrdPerformanceExamRelateDO.remark
                
                )).from(qPrdPerformanceExamRelateDO);
            
    }
    
    
    private Predicate bulidPredicate(PrdPerformanceExamRelateQuery prdPerformanceExamRelateQuery) {
    
        Predicate predicate = PredicateBuilder.builder()
            .andEq(null != prdPerformanceExamRelateQuery.getExamId(), qPrdPerformanceExamRelateDO.examId, prdPerformanceExamRelateQuery.getExamId())
            .andEq(StringUtils.isNotBlank(prdPerformanceExamRelateQuery.getRoleType()), qPrdPerformanceExamRelateDO.roleType, prdPerformanceExamRelateQuery.getRoleType())
            .andEq(null != prdPerformanceExamRelateQuery.getUserId(), qPrdPerformanceExamRelateDO.userId, prdPerformanceExamRelateQuery.getUserId())
            .andEq(null != prdPerformanceExamRelateQuery.getResId(), qPrdPerformanceExamRelateDO.resId, prdPerformanceExamRelateQuery.getResId())
            .build();
            
        return predicate;
        
    }
    
    
    private List<Predicate> bulidPredicates(PrdPerformanceExamRelateQuery prdPerformanceExamRelateQuery) {
        
        List<Predicate> predicates = new ArrayList<>();
        // 绩效考核id
        if (null != prdPerformanceExamRelateQuery.getExamId()) {
            predicates.add(qPrdPerformanceExamRelateDO.examId.eq(prdPerformanceExamRelateQuery.getExamId()));
        }
        // 角色类型
        if (StringUtils.isNotEmpty(prdPerformanceExamRelateQuery.getRoleType())) {
            predicates.add(qPrdPerformanceExamRelateDO.roleType.eq(prdPerformanceExamRelateQuery.getRoleType()));
        }
        // 用户id
        if (null != prdPerformanceExamRelateQuery.getUserId()) {
            predicates.add(qPrdPerformanceExamRelateDO.userId.eq(prdPerformanceExamRelateQuery.getUserId()));
        }
        // 资源id
        if (null != prdPerformanceExamRelateQuery.getResId()) {
            predicates.add(qPrdPerformanceExamRelateDO.resId.eq(prdPerformanceExamRelateQuery.getResId()));
        }
        
//      Predicate predicate = ExpressionUtils.allOf(predicates);
        
        return predicates;
    }
    
    
    public Long count(PrdPerformanceExamRelateQuery prdPerformanceExamRelateQuery) {
    
        long res = select(PrdPerformanceExamRelateVO.class)
                .where(bulidPredicate(prdPerformanceExamRelateQuery))
                .fetchCount();
        
        return res;
        
        
    }
    
    public Long update(PrdPerformanceExamRelatePayload prdPerformanceExamRelatePayload) {
        JPAUpdateClause update = jpaQueryFactory.update(qPrdPerformanceExamRelateDO);
        
        // 绩效考核id
        if (null != prdPerformanceExamRelatePayload.getExamId()) {
            update.set(qPrdPerformanceExamRelateDO.examId,prdPerformanceExamRelatePayload.getExamId());
        }
        // 角色类型
        if (StringUtils.isNotEmpty(prdPerformanceExamRelatePayload.getRoleType())) {
            update.set(qPrdPerformanceExamRelateDO.roleType,prdPerformanceExamRelatePayload.getRoleType());
        }
        // 用户id
        if (null != prdPerformanceExamRelatePayload.getUserId()) {
            update.set(qPrdPerformanceExamRelateDO.userId,prdPerformanceExamRelatePayload.getUserId());
        }
        // 资源id
        if (null != prdPerformanceExamRelatePayload.getResId()) {
            update.set(qPrdPerformanceExamRelateDO.resId,prdPerformanceExamRelatePayload.getResId());
        }
        long res = update.where(qPrdPerformanceExamRelateDO.id.eq(prdPerformanceExamRelatePayload.getId()))
                .execute();
        return res;
    
    }
    
}

