package com.elitesland.tw.tw5.server.prd.humanresources.examination.entity;

import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import lombok.Data;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalDate;
import org.hibernate.annotations.Where;
import com.elitescloud.boot.model.entity.BaseModel;


 /**
 * @author : WWW
 * @date : 2023-11-13
 * @desc : 绩效考核模板等级
 */
 
@Entity
@Table(name="prd_exam_temp_grade")
@org.hibernate.annotations.Table(appliesTo = "prd_exam_temp_grade", comment = "绩效考核模板等级")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0")
public class PrdExamTempGradeDO extends BaseModel {


    /**
     * 模板id
     */
    @Column(name = "temp_id", columnDefinition = "bigint(20) comment '模板id'")
    private Long tempId;
    
    /**
     * 等级名称
     */
    @Column(name = "name", columnDefinition = "varchar(255) comment '等级名称'")
    private String name;
    
    /**
     * 分数占比开始
     */
    @Column(name = "score_ratio_start", columnDefinition = "decimal(20,2) comment '分数占比开始'")
    private BigDecimal scoreRatioStart;
    
    /**
     * 分数占比结束
     */
    @Column(name = "score_ratio_end", columnDefinition = "decimal(20,2) comment '分数占比结束'")
    private BigDecimal scoreRatioEnd;
    

}

