package com.elitesland.tw.tw5.server.prd.humanresources.examination.service;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdExamTempGradeQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdExamTempPointQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdExamTempGradeService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdExamTempPointService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdExamTempService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdExamTempGradeVO;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdExamTempPointVO;
import com.elitesland.tw.tw5.server.prd.humanresources.convert.PrdExamTempConvert;
import com.elitesland.tw.tw5.server.prd.humanresources.examination.dao.PrdExamTempGradeDao;
import com.elitesland.tw.tw5.server.prd.humanresources.examination.dao.PrdExamTempPointDao;
import com.elitesland.tw.tw5.server.prd.humanresources.examination.entity.PrdExamTempDO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdExamTempPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdExamTempQuery;
import com.elitesland.tw.tw5.server.prd.humanresources.examination.repo.PrdExamTempRepo;
import com.elitesland.tw.tw5.server.prd.humanresources.examination.dao.PrdExamTempDao;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdExamTempVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.collection.CollectionUtil;

import java.util.List;


/**
 * @author : WWW
 * @date : 2023-11-13
 * @desc : 绩效考核模板Service
 */

@Slf4j
@Service
@RequiredArgsConstructor
public class PrdExamTempServiceImpl implements PrdExamTempService {


    private final PrdExamTempDao prdExamTempDao;

    private final PrdExamTempRepo prdExamTempRepo;

    private final PrdExamTempGradeService prdExamTempGradeService;

    private final PrdExamTempPointService prdExamTempPointService;


    @Override
    @Transactional(rollbackFor = Exception.class)
    public PrdExamTempVO save(PrdExamTempPayload prdExamTempPayload) {

        checkData(prdExamTempPayload);
        PrdExamTempDO prdExamTempDO = new PrdExamTempDO();
        prdExamTempDO = PrdExamTempConvert.INSTANCE.p2d(prdExamTempPayload);
        PrdExamTempDO res = prdExamTempRepo.save(prdExamTempDO);

        // 考核结果等级
        prdExamTempPayload.getPrdExamTempGradePayloadList().forEach(x -> {
            x.setTempId(res.getId());
            PrdExamTempGradeVO save = prdExamTempGradeService.save(x);

        });
        // 考核点
        prdExamTempPayload.getPrdExamTempPointPayloadList().forEach(x -> {
            x.setTempId(res.getId());
            PrdExamTempPointVO save = prdExamTempPointService.save(x);
        });

        return PrdExamTempConvert.INSTANCE.d2v(res);

    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public PrdExamTempVO update(PrdExamTempPayload prdExamTempPayload) {

        Assert.notNull(prdExamTempPayload.getId(), "id is null");
        // 考核点
        prdExamTempGradeService.delByTempId(prdExamTempPayload.getId());
        // 考核结果等级
        prdExamTempPointService.delByTempId(prdExamTempPayload.getId());
        PrdExamTempVO res = save(prdExamTempPayload);
        return res;
    }


    @Override
    public PrdExamTempVO get(Long id) {

        if (null == id) {
            return null;
        }
        PrdExamTempVO res = prdExamTempDao.get(id);
        // 考核结果等级列表
        PrdExamTempGradeQuery prdExamTempGradeQuery = new PrdExamTempGradeQuery();
        prdExamTempGradeQuery.setTempId(id);
        List<PrdExamTempGradeVO> gradeVOList = prdExamTempGradeService.getList(prdExamTempGradeQuery);
        res.setPrdExamTempGradeVOList(gradeVOList);
        PrdExamTempPointQuery prdExamTempPointQuery = new PrdExamTempPointQuery();
        prdExamTempPointQuery.setTempId(id);
        List<PrdExamTempPointVO> pointVOList = prdExamTempPointService.getList(prdExamTempPointQuery);
        // 考核点列表
        res.setPrdExamTempPointVOList(pointVOList);
        return res;

    }


    @Override
    public PagingVO<PrdExamTempVO> page(PrdExamTempQuery prdExamTempQuery) {

        PagingVO<PrdExamTempVO> res = prdExamTempDao.page(prdExamTempQuery);
        return res;

    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long del(List<Long> ids) {

        if (CollectionUtil.isEmpty(ids)) {
            return 0L;
        }
        Long res = prdExamTempDao.del(ids);
        ids.forEach(x -> {
            // 考核点
            prdExamTempGradeService.delByTempId(x);
            // 考核结果等级
            prdExamTempPointService.delByTempId(x);
        });

        return res;

    }

    @Override
    public List<PrdExamTempVO> getList(PrdExamTempQuery prdExamTempQuery) {

        List<PrdExamTempVO> res = prdExamTempDao.getList(prdExamTempQuery);
        return res;

    }


    /**
     * 数据校验
     *
     * @param prdExamTempPayload
     */
    private void checkData(PrdExamTempPayload prdExamTempPayload) {

        if (StringUtils.isBlank(prdExamTempPayload.getName())) {
            throw new BusinessException("名称不能为空");
        }
        if (null == prdExamTempPayload.getScoreMin()) {
            throw new BusinessException("分数下限不能为空");
        }
        if (null == prdExamTempPayload.getScoreMax()) {
            throw new BusinessException("分数上限不能为空");
        }
        if (null == prdExamTempPayload.getEnableFlag()) {
            throw new BusinessException("是否启用不能为空");
        }

    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long updateByCondition(PrdExamTempPayload prdExamTempPayload) {
        Assert.notNull(prdExamTempPayload.getId(), "id不能为空");
        Long res = prdExamTempDao.update(prdExamTempPayload);
        return res;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long updateState(PrdExamTempPayload prdExamTempPayload) {

        Long res = prdExamTempDao.updateState(prdExamTempPayload);
        return res;
    }


}

