package com.elitesland.tw.tw5.server.prd.humanresources.personnel.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.EmployeeDepartPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.EmployeeDepartApplyQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.EmployeeDepartApplyVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.entity.EmployeeDepartApplyDO;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.entity.QEmployeeDepartApplyDO;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.repo.EmployeeDepartApplyRepo;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgEmployeeDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgEmployeeRefDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgOrganizationDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgRoleDO;
import com.elitesland.tw.tw5.server.prd.partner.common.entity.QBusinessPartnerDO;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

@Repository
@RequiredArgsConstructor
public class EmployeeDepartApplyDAO {

    private final JPAQueryFactory jpaQueryFactory;

    private final QEmployeeDepartApplyDO employeeDepartApplyDO = QEmployeeDepartApplyDO.employeeDepartApplyDO;

    private final QPrdOrgEmployeeDO employeeDO = QPrdOrgEmployeeDO.prdOrgEmployeeDO;

    private final QPrdOrgRoleDO orgRoleDO = QPrdOrgRoleDO.prdOrgRoleDO;

    // private final QPrdOrgCompanyDO qdoCompany = QPrdOrgCompanyDO.prdOrgCompanyDO;

    private final QPrdOrgEmployeeDO n_qdo = new QPrdOrgEmployeeDO("prdOrgEmployeeDO1");

    private final QPrdOrgOrganizationDO qdoOrg = QPrdOrgOrganizationDO.prdOrgOrganizationDO;
    private final QPrdOrgEmployeeRefDO qdoRef = QPrdOrgEmployeeRefDO.prdOrgEmployeeRefDO;

    private final EmployeeDepartApplyRepo employeeDepartApplyRepo;
    private final QBusinessPartnerDO qBusinessPartnerDO = QBusinessPartnerDO.businessPartnerDO;

    public EmployeeDepartApplyDO save(EmployeeDepartApplyDO employeeDepartApplyDO) {
        return employeeDepartApplyRepo.save(employeeDepartApplyDO);
    }

    public void updateProcData(EmployeeDepartPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(employeeDepartApplyDO)
                .where(employeeDepartApplyDO.id.eq(payload.getId()));

        if (payload.getProcInstId() != null) {
            update.set(employeeDepartApplyDO.procInstId, payload.getProcInstId());
        }
        if (payload.getProcInstStatus() != null) {
            update.set(employeeDepartApplyDO.procInstStatus, payload.getProcInstStatus());
        }
        if (payload.getApprovedTime() != null) {
            update.set(employeeDepartApplyDO.approvedTime, payload.getApprovedTime());
        }
        if (payload.getDeleteFlag() != null) {
            update.set(employeeDepartApplyDO.deleteFlag, payload.getDeleteFlag());
        }
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            if (nullFields.contains("procInstStatus")) {
                update.setNull(employeeDepartApplyDO.procInstStatus);
            }
            if (nullFields.contains("procInstId")) {
                update.setNull(employeeDepartApplyDO.procInstId);
            }
        }
        // 执行修改
        update.execute();
    }

    public EmployeeDepartApplyDO findByPrcoId(String procInstId) {
        return employeeDepartApplyRepo.findByProcInstId(procInstId);
    }

    public PagingVO<EmployeeDepartApplyVO> queryPaging(EmployeeDepartApplyQuery query) {
        JPAQuery<EmployeeDepartApplyVO> jpaQuery = getJpaQueryWhere(query);
        QueryResults<EmployeeDepartApplyVO> result = jpaQuery.offset(query.getPageRequest().getOffset()).limit(query.getPageRequest().getPageSize()).fetchResults();
        return PagingVO.<EmployeeDepartApplyVO>builder().records(result.getResults()).total(result.getTotal()).build();
    }

    private JPAQuery<EmployeeDepartApplyVO> getJpaQueryWhere(EmployeeDepartApplyQuery query) {
        JPAQuery<EmployeeDepartApplyVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(employeeDepartApplyDO.deleteFlag.eq(0));
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, employeeDepartApplyDO._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(employeeDepartApplyDO, query.getOrders()));
        return jpaQuery;
    }


    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(EmployeeDepartApplyQuery query) {
        List<Predicate> list = new ArrayList<>();
        /** 记录唯一ID 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(employeeDepartApplyDO.id.eq(query.getId()));
        }

        /** 离职资源 精确 */
        if (!ObjectUtils.isEmpty(query.getUserId())) {
            list.add(employeeDepartApplyDO.userId.eq(query.getUserId()));
        }

        /** 流程名称 精确 */
        if (!ObjectUtils.isEmpty(query.getProcInstName())) {
            list.add(employeeDepartApplyDO.procInstName.like(SqlUtil.toSqlLikeString(query.getProcInstName())));
        }

        /** 流程状态 精确 */
        if (!ObjectUtils.isEmpty(query.getProcInstStatus())) {
            list.add(employeeDepartApplyDO.procInstStatus.eq(query.getProcInstStatus()));
        }

        /** 解除合同日期 精确 */
        if (!ObjectUtils.isEmpty(query.getContractEndDateStart())) {
            list.add(employeeDepartApplyDO.contractEndDate.goe(query.getContractEndDateStart()));
        }
        /** 解除合同日期 精确 */
        if (!ObjectUtils.isEmpty(query.getContractEndDateEnd())) {
            list.add(employeeDepartApplyDO.contractEndDate.loe(query.getContractEndDateEnd()));
        }

        /** 离职原因 精确 */
        if (!ObjectUtils.isEmpty(query.getHrLeaveDescCode())) {
            list.add(employeeDepartApplyDO.hrLeaveDescCode.eq(query.getHrLeaveDescCode()));
        }

        /** 入职日期 精确 */
        if (!ObjectUtils.isEmpty(query.getEnrollDateStart())) {
            list.add(employeeDepartApplyDO.enrollDate.goe(query.getEnrollDateStart()));
        }
        /** 入职日期 精确 */
        if (!ObjectUtils.isEmpty(query.getEnrollDateEnd())) {
            list.add(employeeDepartApplyDO.enrollDate.loe(query.getEnrollDateEnd()));
        }

        /** 默认组织 精确 */
        if (!ObjectUtils.isEmpty(query.getOrgId())) {
            list.add(employeeDepartApplyDO.orgId.eq(query.getOrgId()));
        }

        /** 主服务地 精确 */
        if (!ObjectUtils.isEmpty(query.getExtString5())) {
            list.add(employeeDepartApplyDO.extString5.eq(query.getExtString5()));
        }

        /** 上级资源 精确 */
        if (!ObjectUtils.isEmpty(query.getParentId())) {
            list.add(employeeDepartApplyDO.parentId.eq(query.getParentId()));
        }

        return ExpressionUtils.allOf(list);
    }

    private JPAQuery<EmployeeDepartApplyVO> getJpaQuerySelect() {
        // todo wly
        return jpaQueryFactory.select(Projections.bean(EmployeeDepartApplyVO.class,
                        employeeDepartApplyDO.id,
                        employeeDepartApplyDO.employeeId,
                        employeeDepartApplyDO.userId,
                        employeeDepartApplyDO.procInstStatus,
                        employeeDepartApplyDO.contractEndDate,
                        employeeDepartApplyDO.hrLeaveDescCode,
                        employeeDepartApplyDO.enrollDate,
                        employeeDepartApplyDO.bookId,
                        employeeDepartApplyDO.orgId,
                        employeeDepartApplyDO.extString5,
                        employeeDepartApplyDO.parentId,
                        employeeDepartApplyDO.jobHandOverFlag,
                        employeeDepartApplyDO.jobHandOverId,
                        employeeDepartApplyDO.jobContent,
                        employeeDepartApplyDO.emailSet,
                        employeeDepartApplyDO.emailReceiverId,
                        employeeDepartApplyDO.email,
                        employeeDepartApplyDO.employeeNo,
                        employeeDepartApplyDO.hrReason,
//                        qdoRef.parentId,
                        employeeDepartApplyDO.employeeId,
                        employeeDepartApplyDO.createTime,
                        employeeDO.employeeName,
                        qBusinessPartnerDO.partnerName.as("companyName"),
//                        n_qdo.employeeName.as("parentName"),
                        qdoOrg.orgName,
                        employeeDepartApplyDO.leaveDesc,
                        employeeDepartApplyDO.procInstName,
                        employeeDepartApplyDO.procInstId,
                        employeeDepartApplyDO.lastJobDate
                )).from(employeeDepartApplyDO)
                .leftJoin(employeeDO).on(employeeDO.id.eq(employeeDepartApplyDO.employeeId))
                .leftJoin(qdoRef).on(employeeDO.userId.longValue().eq(qdoRef.userId.longValue()).and(qdoRef.isDefault.eq(0)).and(qdoRef.isCopy.eq(0)).and(qdoRef.deleteFlag.eq(0)))
                .leftJoin(qdoOrg).on(qdoOrg.id.longValue().eq(qdoRef.orgId.longValue()).and(qdoOrg.isCopy.eq(0)))
                .leftJoin(n_qdo).on(n_qdo.userId.longValue().eq(qdoRef.parentId.longValue()).and(n_qdo.deleteFlag.eq(0)))
                .leftJoin(qBusinessPartnerDO).on(qBusinessPartnerDO.bookId.longValue().eq(employeeDO.bookId.longValue()));
    }

    public List<String> queryOrgRoleByUserId(String userId) {
        return jpaQueryFactory.select(orgRoleDO.roleName)
                .from(orgRoleDO)
                .where(orgRoleDO.roleEmployees.like(SqlUtil.toSqlLikeString(userId)))
                .fetch();
    }

    public EmployeeDepartApplyVO queryByKey(Long applyId) {
        return getJpaQuerySelect().where(employeeDepartApplyDO.id.eq(applyId)).fetchFirst();
    }

    public List<EmployeeDepartApplyDO> queryByEmployeeId(Long employeeId) {
        return employeeDepartApplyRepo.findAllByEmployeeId(employeeId);
    }
}
