package com.elitesland.tw.tw5.server.prd.humanresources.personnel.dao;

import com.elitesland.tw.tw5.server.prd.humanresources.personnel.entity.PersonWorkExperienceDO;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.entity.QPersonWorkExperienceDO;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.repo.PersonWorkExperienceRepo;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
@RequiredArgsConstructor
public class PersonWorkExperienceDAO {

    private final PersonWorkExperienceRepo personWorkExperienceRepo;
    private final JPAQueryFactory jpaQueryFactory;

    private final QPersonWorkExperienceDO personWorkExperienceDO = QPersonWorkExperienceDO.personWorkExperienceDO;


    public List<PersonWorkExperienceDO> findAllByPersonId(Long personId) {
        return personWorkExperienceRepo.findAllByPersonId(personId);
    }

    public void deleteAllByPersonId(Long personId) {
        jpaQueryFactory.update(personWorkExperienceDO)
                .set(personWorkExperienceDO.deleteFlag, 1)
                .where(personWorkExperienceDO.personId.eq(personId))
                .execute();
    }

    public void saveAll(List<PersonWorkExperienceDO> personWorkExperienceDOList) {
        personWorkExperienceRepo.saveAll(personWorkExperienceDOList);
    }
}
