package com.elitesland.tw.tw5.server.prd.humanresources.personnel.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitesland.workflow.enums.ProcInstStatus;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import java.time.LocalDateTime;

@Entity
@Table(name = "employee_depart_apply", indexes = {
        @Index(name = "employee_index", columnList = "employee_id"),
})
@org.hibernate.annotations.Table(appliesTo = "employee_depart_apply", comment = "员工离职申请表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class EmployeeDepartApplyDO extends BaseModel {

    @Comment("离职资源")
    @Column(name = "employee_id")
    private Long employeeId;

    @Comment("离职资源userID")
    @Column()
    private Long userId;

    @Comment("入职日期")
    @Column()
    private String enrollDate;

    @Comment("组织")
    @Column()
    private Long orgId;

    @Comment("Base地")
    @Column()
    private String extString5;

//    @Comment("所属公司")
//    @Column()
//    private Long companyId;

    @Comment("所属公司")
    @Column()
    private Long bookId;

    @Comment("直属领导")
    @Column()
    private Long parentId;

    @Comment("备注(离职原因)")
    @Column()
    private String leaveDesc;

    @Comment("有无工作交接")
    @Column()
    private String jobHandOverFlag;

    @Comment("工作交接人")
    @Column()
    private Long jobHandOverId;

    @Comment("工作交接内容")
    @Column()
    private String jobContent;

    @Comment("解除劳动合同日期")
    @Column()
    private String contractEndDate;

    @Comment("邮箱")
    @Column()
    private String email;

    @Comment("邮箱设置")
    @Column()
    private String emailSet;

    @Comment("邮件代收人")
    @Column()
    private Long emailReceiverId;

    @Comment("最后工作日")
    @Column()
    private String lastJobDate;

    @Comment("工号")
    @Column()
    private String employeeNo;

    @Comment("离职原因")
    @Column()
    private String hrLeaveDescCode;

    @Comment("离职原因说明")
    @Column()
    private String hrReason;

    @Comment("流程实例ID")
    @Column()
    private String procInstId;

    @Comment("流程名称")
    @Column()
    private String procInstName;

    @Comment("流程审批状态")
    @Column()
    @Enumerated(EnumType.STRING)
    private ProcInstStatus procInstStatus;

    @Comment("审批时间")
    @Column()
    private LocalDateTime approvedTime;

    @Column(columnDefinition = "LONGTEXT")
    @Comment("离职办理事项-财务")
    private String leaveFinChk;

    @Column(columnDefinition = "LONGTEXT")
    @Comment("离职办理事项-人事")
    private String leaveHrChk;

    @Column(columnDefinition = "LONGTEXT")
    @Comment("离职办理事项-IT")
    private String leaveItChk;

    @Column(columnDefinition = "LONGTEXT")
    @Comment("离职办理事项-资源")
    private String leaveResChk;

    @Column(columnDefinition = "LONGTEXT")
    @Comment("离职办理事项-行政")
    private String leaveOffiChk;

    @Comment("是否已安排休完剩余假期")
    @Column
    private Boolean availableVacationUsedFlag;

    public void copy(EmployeeDepartApplyDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
