package com.elitesland.tw.tw5.server.prd.humanresources.recommended.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

import org.hibernate.annotations.Where;

import javax.persistence.*;
import javax.validation.constraints.*;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 内部招聘-我的推荐
 *
 * @author zhangxiao
 * @date 2023-12-14
 */
@Entity
@Table(name = "prd_internal_recomm", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "prd_internal_recomm", comment = "内部招聘-我的推荐")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PrdInternalRecommDO extends BaseModel implements Serializable {
    /**
     * 岗位id
     */
    @Comment("岗位id")
    @Column()
    private Long positId;
    /**
     * 内部推荐编号
     */
    @Comment("内部推荐编号")
    @Column()
    private String docNo;
    /**
     * 采用奖励
     */
    @Comment("采用奖励")
    @Column()
    private String adoptReward;
    /**
     * 转正日期
     */
    @Comment("转正日期")
    @Column()
    private LocalDate formalDate;
    /**
     * 推荐日期
     */
    @Comment("推荐日期")
    @Column()
    private LocalDate recommDate;
    /**
     * 是否入职 true 入职 false 不入职
     */
    @Comment("是否入职 true 入职 false 不入职")
    @Column()
    private Boolean entryFlag;
    /**
     * 是否转正 true 转正 false 不转正
     */
    @Comment("是否转正 true 转正 false 不转正")
    @Column()
    private Boolean formalFlag;
    /**
     * 筛选结果 1、采用 2、不合适 3、简历重复 4、招聘取消
     */
    @Comment("筛选结果 1、采用 2、不合适 3、简历重复 4、招聘取消")
    @Column()
    private Integer filterResult;
    /**
     * 招聘负责人
     */
    @Comment("招聘负责人")
    @Column()
    private Long managerUserId;
    /**
     * 转转奖励
     */
    @Comment("转转奖励")
    @Column()
    private String formalReward;
    /**
     * 被推荐人名称
     */
    @Comment("被推荐人名称")
    @Column()
    private String recommUserName;
    /**
     * 推荐人简历
     */
    @Comment("推荐人简历")
    @Column()
    private String recommResume;
    /**
     * 推荐人手机号
     */
    @Comment("推荐人手机号")
    @Column()
    private String recommPhone;
    /**
     * 推荐状态 1、未提交2、审批中3、已通过4、撤回5、关闭6、已拒绝
     */
    @Comment("推荐状态 1、未提交2、审批中3、已通过4、撤回5、关闭6、已拒绝")
    @Column()
    private Integer recommStatus;
    /**
     * 与推荐人关系
     */
    @Comment("与推荐人关系")
    @Column()
    private String relate;
    /**
     * 推荐理由
     */
    @Column(name = "reason", columnDefinition = "varchar(500) comment '推荐理由'")
    private String reason;
    /**
     * 被推荐人档案id
     */
    @Comment("被推荐人档案id")
    @Column()
    private Long recommUserId;

    /**
     * 流程实例ID
     */
    @Comment("流程实例ID")
    @Column()
    private String procInstId;
    /**
     * 流程审批状态
     */
    @Comment("流程审批状态")
    @Column()
    private ProcInstStatus procInstStatus;
    /**
     * 提交时间
     */
    @Comment("提交时间")
    @Column()
    private LocalDateTime submitTime;
    /**
     * 审批时间
     */
    @Comment("审批时间")
    @Column()
    private LocalDateTime approvedTime;

    /**
     * 档案id
     */
    @Column(name = "person_id", columnDefinition = "bigint(20) comment '档案id'")
    private Long personId;

    /**
     * 档案名称
     */
    @Column(name = "person_name", columnDefinition = "varchar(255) comment '档案名称'")
    private String personName;

    public void copy(PrdInternalRecommDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
