package com.elitesland.tw.tw5.server.prd.humanresources.recommended.service;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdInternalRecommPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdInternalRecommQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdInternalRecommService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdRecruitPositionService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdInternalRecommVO;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdRecruitPositionVO;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgPersonService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgPersonVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemRoleService;
import com.elitesland.tw.tw5.server.common.GenerateSeqNumConstants;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.common.workFlow.ProcDefKey;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.humanresources.recommended.convert.PrdInternalRecommConvert;
import com.elitesland.tw.tw5.server.prd.humanresources.recommended.dao.PrdInternalRecommDAO;
import com.elitesland.tw.tw5.server.prd.humanresources.recommended.entity.PrdInternalRecommDO;
import com.elitesland.tw.tw5.server.prd.humanresources.recommended.repo.PrdInternalRecommRepo;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.payload.StartProcessPayload;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;

/**
 * 内部招聘-我的推荐
 *
 * @author zhangxiao
 * @date 2023-12-14
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PrdInternalRecommServiceImpl extends BaseServiceImpl implements PrdInternalRecommService {

    private final PrdInternalRecommRepo prdInternalRecommRepo;
    private final PrdInternalRecommDAO prdInternalRecommDAO;
    private final PrdRecruitPositionService prdRecruitPositionService;
    @Value("${tw5.workflow.enabled}")
    private Boolean workflow_enabled;
    private final WorkflowUtil workflowUtil;
    private final TransactionUtilService transactionUtilService;
    private final FileUtil fileUtil;
    private final PrdSystemRoleService roleService;
    private final CacheUtil cacheUtil;
    private final PrdOrgPersonService personService;

    @Override
    public PagingVO<PrdInternalRecommVO> queryPaging(PrdInternalRecommQuery query) {
        PagingVO<PrdInternalRecommVO> pagingVO = prdInternalRecommDAO.queryPaging(query);
        for (PrdInternalRecommVO prdInternalRecommVO : pagingVO.getRecords()) {
            prdInternalRecommVO.setRecommResumeFileList(fileUtil.getFileDatas(prdInternalRecommVO.getRecommResume()));
            prdInternalRecommVO.setJobType1Desc(cacheUtil.transferSystemSelection("INTERIOR_RECO:TYPE", prdInternalRecommVO.getJobType1()));
            prdInternalRecommVO.setJobType2Desc(cacheUtil.transferSystemSelection("INTERIOR_RECO:TYPE", prdInternalRecommVO.getJobType2()));
//            prdInternalRecommVO.setBaseBuName(cacheUtil.getOrgName(prdInternalRecommVO.getBaseBuId()));
            prdInternalRecommVO.setManagerUserName(cacheUtil.getUserName(prdInternalRecommVO.getManagerUserId()));
        }
        return pagingVO;
    }

    @Override
    public List<PrdInternalRecommVO> queryListDynamic(PrdInternalRecommQuery query) {
        return prdInternalRecommDAO.queryListDynamic(query);
    }

    @Override
    public PrdInternalRecommVO queryByKey(Long key) {
        PrdInternalRecommDO entity = prdInternalRecommRepo.findById(key).orElseGet(PrdInternalRecommDO::new);
        Assert.notNull(entity.getId(), "不存在");
        PrdInternalRecommVO vo = PrdInternalRecommConvert.INSTANCE.toVo(entity);
        vo.setPosIt(entity.getPositId());
        vo.setRecommResumeFileList(fileUtil.getFileDatas(vo.getRecommResume()));
        return vo;
    }

    @Override
    public PrdInternalRecommVO insert(PrdInternalRecommPayload payload) {
        checkData(payload);
        // 校验人员是否已推荐过
//        PrdInternalRecommQuery prdInternalRecommQuery = new PrdInternalRecommQuery();
//        prdInternalRecommQuery.setRecommPhone(payload.getRecommPhone());
//        long count = prdInternalRecommDAO.count(prdInternalRecommQuery);
//        if (count > 0) {
//            throw new BusinessException("该人员已被推荐过");
//        }
        //内部我的推荐编号
        payload.setDocNo(generateSeqNum(GenerateSeqNumConstants.MY_RECOMMEND_NO));
        PrdInternalRecommDO entityDo = PrdInternalRecommConvert.INSTANCE.toDo(payload);
        entityDo.setPositId(payload.getPosIt());
        PrdOrgPersonVO orgPersonVO = personService.getByMobile(payload.getRecommPhone());
        // 个人档案信息
        if (null != orgPersonVO) {
            entityDo.setPersonId(orgPersonVO.getId());
            entityDo.setPersonName(orgPersonVO.getPersonName());
        }

        PrdInternalRecommDO save = null;
        try {
            transactionUtilService.begin();
            save = prdInternalRecommRepo.save(entityDo);
            transactionUtilService.commit();
        } catch (Exception e) {
            transactionUtilService.rollback();
            throw e;
        }


        if (payload.getSubmit()) {
            startProcInst(save);
        }
        return PrdInternalRecommConvert.INSTANCE.toVo(save);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PrdInternalRecommVO update(PrdInternalRecommPayload payload) {
        checkData(payload);
        PrdInternalRecommDO entity = prdInternalRecommRepo.findById(payload.getId()).orElseGet(PrdInternalRecommDO::new);
        Assert.notNull(entity.getId(), "不存在");
        PrdInternalRecommDO entityDo = PrdInternalRecommConvert.INSTANCE.toDo(payload);
        entityDo.setPositId(payload.getPosIt());
        entity.copy(entityDo);
        if (payload.getSubmit()) {
            startProcInst(entityDo);
        }
        return PrdInternalRecommConvert.INSTANCE.toVo(prdInternalRecommRepo.save(entity));
    }

    private void startProcInst(PrdInternalRecommDO prdInternalRecommDO) {
        ProcessInfo processInfo = new ProcessInfo();
        //获取岗位招聘人Id
        PrdRecruitPositionVO prdRecruitPositionVO = prdRecruitPositionService.queryByKey(prdInternalRecommDO.getPositId());
        if (prdRecruitPositionVO == null) {
            throw new BusinessException("岗位为null");
        }
        Integer recommStatus = 1;
        if (workflow_enabled) {
            recommStatus = 2;
            HashMap<String, Object> variables = new HashMap<>();
            // 招聘负责人审批
            variables.put("Activity_0i2vxh5", roleService.queryUserIdByRoleCode("PLAT_HIRING_MANAGER"));
            //发起流程审批
            processInfo = workflowUtil.startProcess(StartProcessPayload.of(
                    ProcDefKey.INTERIOR_RECO.name(),
                    prdInternalRecommDO.getRecommUserName() + "-内部推荐审批流程",
                    prdInternalRecommDO.getId() + "",
                    variables)
            );
        }
        // 流程启动成功后，回写业务表数据
        PrdInternalRecommPayload payload = new PrdInternalRecommPayload();
        payload.setProcInstId(processInfo.getProcInstId());
        payload.setAdoptReward(prdInternalRecommDO.getAdoptReward());
        payload.setFilterResult(prdInternalRecommDO.getFilterResult());
        payload.setRecommUserId(prdInternalRecommDO.getRecommUserId());
        payload.setId(prdInternalRecommDO.getId());
        payload.setProcInstStatus(processInfo.getProcInstStatus());

        payload.setRecommStatus(recommStatus);
        payload.setSubmitTime(LocalDateTime.now());
        payload.setApprovedTime(LocalDateTime.now());
        // 开启事务执行修改，主要是修改审批状态
        transactionUtilService.executeWithRunnable(() -> {
            prdInternalRecommDAO.updateByKeyDynamic(payload);
        });
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(PrdInternalRecommPayload payload) {
        PrdInternalRecommDO entity = prdInternalRecommRepo.findById(payload.getId()).orElseGet(PrdInternalRecommDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = prdInternalRecommDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            prdInternalRecommDAO.deleteSoft(keys);
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Boolean updateFormalReward(PrdInternalRecommPayload prdInternalRecommPayload) {

        Boolean res = prdInternalRecommDAO.updateFormalReward(prdInternalRecommPayload);
        return res;
    }

    @Override
    public PrdInternalRecommVO getByPersonId(String name, Long personId) {
        List<PrdInternalRecommVO> res = prdInternalRecommDAO.getByPersonId(name, personId);
        if (CollUtil.isNotEmpty(res)) {
            return res.get(0);
        }
        return null;
    }

    @Override
    @Transactional
    public Boolean updateByPersonId(PrdInternalRecommPayload prdInternalRecommPayload) {

        Boolean res = prdInternalRecommDAO.updateByPersonId(prdInternalRecommPayload);

        return res;
    }


    /**
     * 数据校验
     *
     * @param prdInternalRecommPayload
     */
    private void checkData(PrdInternalRecommPayload prdInternalRecommPayload) {

        if (StringUtils.isBlank(prdInternalRecommPayload.getRecommUserName())) {
            throw new BusinessException("被推荐人名称字段不能为空");
        }
        if (StringUtils.isBlank(prdInternalRecommPayload.getRecommPhone())) {
            throw new BusinessException("被推荐人手机号字段不能为空");
        }
        if (StringUtils.isBlank(prdInternalRecommPayload.getRecommResume())) {
            throw new BusinessException("推荐人简历字段不能为空");
        }
        if (prdInternalRecommPayload.getManagerUserId() == null) {
            throw new BusinessException("招聘人字段不能为空");
        }
        if (prdInternalRecommPayload.getRecommDate() == null) {
            throw new BusinessException("推荐日期字段不能为空");
        }
        if (prdInternalRecommPayload.getPosIt() == null) {
            throw new BusinessException("岗位id字段不能为空");
        }
    }

}
