package com.elitesland.tw.tw5.server.prd.my.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.RewardLeaveApplyPayload;
import com.elitesland.tw.tw5.api.prd.my.query.RewardLeaveAppliedQuery;
import com.elitesland.tw.tw5.api.prd.my.query.RewardLeaveApplyQuery;
import com.elitesland.tw.tw5.api.prd.my.service.RewardLeaveApplyService;
import com.elitesland.tw.tw5.api.prd.my.vo.RewardAppliedDaysVO;
import com.elitesland.tw.tw5.api.prd.my.vo.RewardLeaveApplyDetailVO;
import com.elitesland.tw.tw5.api.prd.my.vo.RewardLeaveApplyVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 奖励假申请
 *
 * @author vincent
 * @date 2024-04-11
 */
@Api(tags = "奖励假申请")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/my/rewardLeaveApply")
@Slf4j
public class RewardLeaveApplyController {

    private final RewardLeaveApplyService rewardLeaveApplyService;

    /**
     * 奖励假申请-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("奖励假申请-新增")
    public TwOutputUtil<RewardLeaveApplyVO> insert(@RequestBody RewardLeaveApplyPayload payload) {
        return TwOutputUtil.ok(rewardLeaveApplyService.insert(payload));
    }

    /**
     * 奖励假申请-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("奖励假申请-更新")
    public TwOutputUtil<RewardLeaveApplyVO> update(@RequestBody RewardLeaveApplyPayload payload) {
        return TwOutputUtil.ok(rewardLeaveApplyService.update(payload));
    }

    /**
     * 奖励假申请-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("奖励假申请-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody RewardLeaveApplyPayload payload) {
        return TwOutputUtil.ok(rewardLeaveApplyService.updateByKeyDynamic(payload));
    }

    /**
     * 奖励假申请-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    @UdcNameClass
    @ApiOperation("奖励假申请-主键查询")
    public TwOutputUtil<RewardLeaveApplyVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(rewardLeaveApplyService.queryByKey(key));
    }

    /**
     * 奖励假申请-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("奖励假申请-分页")
    public TwOutputUtil<PagingVO<RewardLeaveApplyVO>> paging(RewardLeaveApplyQuery query) {
        return TwOutputUtil.ok(rewardLeaveApplyService.queryPaging(query));
    }

    /**
     * 奖励假申请-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("奖励假申请-查询列表")
    public TwOutputUtil<List<RewardLeaveApplyVO>> queryList(RewardLeaveApplyQuery query) {
        return TwOutputUtil.ok(rewardLeaveApplyService.queryListDynamic(query));
    }

    /**
     * 奖励假申请-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("奖励假申请-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        rewardLeaveApplyService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    /**
     * 奖励假申请-提交
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("/submit")
    @ApiOperation("奖励假申请-提交")
    public TwOutputUtil<RewardLeaveApplyVO> submit(@RequestBody RewardLeaveApplyPayload payload) {
        return TwOutputUtil.ok(rewardLeaveApplyService.submit(payload));
    }


    /**
     * 奖励假申请-查询列表
     *
     * @param vacationId 假期id
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/vacationDetail")
    @UdcNameClass
    @ApiOperation("奖励假假期明细查看")
    public TwOutputUtil<List<RewardLeaveApplyDetailVO>> queryRewardDetailByVacationId(Long vacationId) {
        return TwOutputUtil.ok(rewardLeaveApplyService.queryRewardDetailByVacationId(vacationId));
    }

    /**
     * 奖励假申请-查询人员已申请天数
     *
     * @param query
     * @return {@link TwOutputUtil}
     */
    @PostMapping("/queryAppliedDays")
    @UdcNameClass
    @ApiOperation("查询人员已申请天数")
    public TwOutputUtil<List<RewardAppliedDaysVO>> countDaysByUserAndReason(@RequestBody RewardLeaveAppliedQuery query) {
        return TwOutputUtil.ok(rewardLeaveApplyService.countDaysByUserAndReason(query));
    }

}

