package com.elitesland.tw.tw5.server.prd.my.dao;

import com.elitesland.tw.tw5.api.prd.my.vo.PrdUserDataVO;
import com.elitesland.tw.tw5.api.prd.my.vo.PrdUserRemindVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgDataRefVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeRefVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemMenuVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemShortcutVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.my.entity.PrdUserRemindDO;
import com.elitesland.tw.tw5.server.prd.my.entity.QPrdUserRemindDO;
import com.elitesland.tw.tw5.server.prd.my.repo.PrdUserRemindRepo;
import com.elitesland.tw.tw5.server.prd.org.entity.*;
import com.elitesland.tw.tw5.server.prd.partner.common.entity.QBusinessPartnerDO;
import com.elitesland.tw.tw5.server.prd.system.entity.*;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 系统选择项dao
 *
 * @author wangding
 */
@Repository
@RequiredArgsConstructor
public class PrdUserDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final PrdUserRemindRepo userRemindRepo;
    private final QPrdOrgEmployeeDO qdo = QPrdOrgEmployeeDO.prdOrgEmployeeDO;
    private final QPrdOrgOrganizationDO qdoOrg = QPrdOrgOrganizationDO.prdOrgOrganizationDO;
    private final QPrdOrgEmployeeRefDO qdoRef = QPrdOrgEmployeeRefDO.prdOrgEmployeeRefDO;
    private final QPrdOrgRoleDO qdoRole = QPrdOrgRoleDO.prdOrgRoleDO;
    private final QPrdSystemShortcutDO qdoShortcut = QPrdSystemShortcutDO.prdSystemShortcutDO;
    private final QPrdSystemMenuDO qdoMenu = QPrdSystemMenuDO.prdSystemMenuDO;
    private final QPrdSystemRoleMenuDO qdoRoleMenu = QPrdSystemRoleMenuDO.prdSystemRoleMenuDO;
    private final QPrdSystemRoleDO qdoSysRole = QPrdSystemRoleDO.prdSystemRoleDO;
    private final QPrdSystemUserRoleDO qdoUserRole = QPrdSystemUserRoleDO.prdSystemUserRoleDO;
    // private final QPrdOrgCompanyDO qdoCompany = QPrdOrgCompanyDO.prdOrgCompanyDO;
    private final QPrdOrgPersonDO qdoPerson = QPrdOrgPersonDO.prdOrgPersonDO;

    private final QPrdRemindConfigDO qdoRemind = QPrdRemindConfigDO.prdRemindConfigDO;
    private final QPrdUserRemindDO qdoUserRemind = QPrdUserRemindDO.prdUserRemindDO;
    private final QBusinessPartnerDO qbusinessPartnerDO = QBusinessPartnerDO.businessPartnerDO;

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public PrdUserRemindDO saveUserRemind(PrdUserRemindDO ado) {
        return userRemindRepo.save(ado);
    }

    /**
     * 查我的提醒
     *
     * @param userId
     * @return 结果
     */
    public PrdUserRemindDO queryUserRemind(Long userId, String type) {
        JPAQuery<PrdUserRemindDO> jpaQuery = jpaQueryFactory.select(qdoUserRemind).from(qdoUserRemind);
        jpaQuery.where(qdoUserRemind.userId.eq(userId));
        jpaQuery.where(qdoUserRemind.remindType.eq(type));
        return jpaQuery.fetchFirst();
    }

    /**
     * 查询我的所有提醒
     *
     * @return jpaQuery对象
     */
    public List<PrdUserRemindVO> queryReminds(Long userId) {
        JPAQuery<PrdUserRemindVO> jpaQuery = jpaQueryFactory.select(Projections.bean(PrdUserRemindVO.class,
                qdoRemind.id,
                qdoRemind.remindType,
                qdoRemind.remindContent,
                qdoRemind.remindTitle,
                qdoRemind.priority,
                qdoUserRemind.noRemindDate,
                qdoUserRemind.createTime
        )).from(qdoRemind).leftJoin(qdoUserRemind).on(qdoRemind.remindType.eq(qdoUserRemind.remindType).and(qdoUserRemind.userId.eq(userId)));

        jpaQuery.where(qdoRemind.deleteFlag.eq(0));
        return jpaQuery.fetch();
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PrdOrgEmployeeRefVO> getJpaQueryDataSelect() {
        return jpaQueryFactory.select(Projections.bean(PrdOrgEmployeeRefVO.class,
                qdoRef.id,
                qdoRef.userId,
                qdoRef.orgId,
                qdoRef.parentId,
                qdo.employeeName,
                qdoRef.joinDate,
                qdoRef.leaveDate,
                qdoRef.isDefault,
                qdoRef.remark,
                qdoRef.createUserId,
                qdo.extString5,
                qdoRef.createTime
        )).from(qdoRef).leftJoin(qdo).on(qdo.userId.longValue().eq(qdoRef.userId.longValue()));
    }

    /**
     * 查询个人所有下级数据
     *
     * @return 结果
     */
    public List<PrdOrgEmployeeRefVO> queryLowListByKey(Long orgId, Long userId) {
        JPAQuery<PrdOrgEmployeeRefVO> jpaQuery = getJpaQueryDataSelect();
        jpaQuery.where(qdoRef.parentId.eq(userId));
        jpaQuery.where(qdoRef.deleteFlag.eq(0));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        jpaQuery.where(qdoRef.isCopy.eq(0));
        jpaQuery.where(qdo.resourceStatus.ne(String.valueOf(6)));
        if (orgId != null) {
            jpaQuery.where(qdoRef.orgId.eq(orgId));
        }
        return jpaQuery.fetch();
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PrdOrgDataRefVO> getJpaQueryOrgSelect() {
        return jpaQueryFactory.select(Projections.bean(PrdOrgDataRefVO.class,
                qdoRef.id,
                qdoRef.userId,
                qdoRef.orgId,
                qdoRef.parentId,
                qdoRef.joinDate,
                qdoRef.leaveDate,
                qdoRef.isDefault,
                qdoOrg.orgName,
                qdoRef.remark,
                qdoRef.createUserId,
                qdoRef.createTime
        )).from(qdoRef).leftJoin(qdoOrg).on(qdoOrg.id.longValue().eq(qdoRef.orgId.longValue()));
    }


    /**
     * 查询个人组织
     *
     * @return 结果
     */
    public List<PrdOrgDataRefVO> queryOrgListByKey(Long userId) {
        JPAQuery<PrdOrgDataRefVO> jpaQuery = getJpaQueryOrgSelect();
        jpaQuery.where(qdoRef.userId.eq(userId));
        jpaQuery.where(qdoRef.deleteFlag.eq(0));
        jpaQuery.where(qdoOrg.deleteFlag.eq(0));
        jpaQuery.where(qdoRef.isCopy.eq(0));
        return jpaQuery.fetch();
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PrdUserDataVO> getJpaQueryEmployeeSelect() {
        //todo wly
        return jpaQueryFactory.select(Projections.bean(PrdUserDataVO.class,
                        qdo.id,
                        qdo.shortcutIds,
                        qdo.employeeName,
                        qdo.jobs,
                        qdo.userId,
                        qdo.extString1,
                        qdo.extString2,
                        qdo.extString3,
                        qdo.extString4,
                        qdo.extString5,
                        qdo.extString6,
                        // qdo.companyId,
                        qdo.bookId,
                        qdo.eqvaRatio,
                        qbusinessPartnerDO.partnerName.as("companyName"),
                        qdoPerson.headCodes,
                        qdoRef.orgId,
                        qdoRef.parentId,
                        qdoOrg.orgName,
                        qdoOrg.organizationType,
                        qdo.extString1,
                        qdo.extString5.as("baseCity"),
                        qdo.extString8.as("monthlyAmt"),
                        qdoPerson.email,
                        qdo.employeeNo
                )).from(qdo).leftJoin(qdoRef).on(qdo.userId.longValue().eq(qdoRef.userId.longValue()).and(qdoRef.deleteFlag.eq(0)).and(qdoRef.isCopy.eq(0)).and(qdoRef.isDefault.eq(0)))
                .leftJoin(qdoOrg).on(qdoOrg.id.longValue().eq(qdoRef.orgId.longValue()).and(qdoOrg.deleteFlag.eq(0)))
                .leftJoin(qbusinessPartnerDO).on(qbusinessPartnerDO.bookId.longValue().eq(qdo.bookId.longValue()).and(qbusinessPartnerDO.deleteFlag.eq(0)))
                .leftJoin(qdoPerson).on(qdoPerson.id.longValue().eq(qdo.personId.longValue()))
                ;
    }

    /**
     * 拼装查询快捷入口
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PrdSystemShortcutVO> getJpaQueryShortcutSelect() {
        return jpaQueryFactory.select(Projections.bean(PrdSystemShortcutVO.class,
                qdoShortcut.id,
                qdoShortcut.shortcutName,
                qdoShortcut.portalRoute,
                qdoShortcut.shortcutIcon,
                qdoShortcut.sortIndex,
                qdoShortcut.type,
                qdoShortcut.webType,
                qdoShortcut.fixFlag,
                qdoShortcut.createUserId,
                qdoShortcut.createTime
        )).from(qdoShortcut);

    }

    /**
     * 查询所有快捷入口
     *
     * @param
     * @return 结果
     */
    public List<PrdSystemShortcutVO> queryShortcutList() {
        JPAQuery<PrdSystemShortcutVO> jpaQuery = getJpaQueryShortcutSelect();
        jpaQuery.where(qdoShortcut.deleteFlag.eq(0));
        jpaQuery.where(qdoShortcut.shortcutStatus.eq(1));
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdoShortcut, SqlUtil.getOrderse()));
        return jpaQuery.fetch();
    }

    /**
     * 查询用户
     *
     * @param userId
     * @return 结果
     */
    public PrdUserDataVO queryUserDetail(Long userId) {
        JPAQuery<PrdUserDataVO> jpaQuery = getJpaQueryEmployeeSelect();
        jpaQuery.where(qdo.userId.eq(userId));
        jpaQuery.where(qdoPerson.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 查角色
     *
     * @param userId
     * @return 结果
     */
    public List<String> queryRolesById(String userId) {
        JPAQuery<String> jpaQuery = jpaQueryFactory.select(qdoRole.roleCode).from(qdoRole);
        jpaQuery.where(qdoRole.roleEmployees.like(SqlUtil.toSqlLikeString(userId)));
        return jpaQuery.fetch();
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PrdUserDataVO> getJpaQueryEmployeeTicket() {
        return jpaQueryFactory.select(Projections.bean(PrdUserDataVO.class,
                qdo.id,
                qdo.pcLoginTicket,
                qdo.employeeNo,
                qdo.employeeName,
                qdoPerson.email
        )).from(qdo).leftJoin(qdoPerson).on(qdoPerson.id.longValue().eq(qdo.personId.longValue()));
    }

    /**
     * 查询用户
     *
     * @param ticket
     * @return 结果
     */
    public PrdUserDataVO queryUserByTicket(String ticket) {
        JPAQuery<PrdUserDataVO> jpaQuery = getJpaQueryEmployeeTicket();
        jpaQuery.where(qdo.pcLoginTicket.eq(ticket));
        jpaQuery.where(qdoPerson.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 修改ticket
     *
     * @param id
     * @param ticket
     * @return
     */
    public long updateTicket(Long id, String ticket) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.pcLoginTicket, ticket)
                .where(qdo.id.eq(id));
        return update.execute();
    }

    /**
     * 修改快捷入口值
     *
     * @param userId
     * @param shortcutIds 快捷入口ids
     * @return
     */
    public long updateShortcut(Long userId, String shortcutIds) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.shortcutIds, shortcutIds)
                .where(qdo.userId.eq(userId));
        return update.execute();
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PrdSystemMenuVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(PrdSystemMenuVO.class,
                qdoMenu.id,
                qdoMenu.parentId,
                qdoMenu.menuCode,
                qdoMenu.menuName,
                qdoMenu.menuStatus,
                qdoMenu.portalRoute,
                qdoMenu.menuIcon,
                qdoMenu.sortIndex,
                qdoMenu.remark,
                qdoMenu.deleteFlag,
                qdoMenu.createUserId,
                qdoMenu.createTime
        )).from(qdoMenu);
    }

    /**
     * 动态查询集合
     *
     * @return 结果集合
     */
    public List<PrdSystemMenuVO> queryUsableList() {
        JPAQuery<PrdSystemMenuVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdoMenu.menuStatus.eq(0));
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdoMenu, SqlUtil.getOrderse()));
        return jpaQuery.fetch();
    }

    /**
     * 列表查询
     *
     * @param userId 用户id
     * @return vo对象
     */
    public List<Long> queryUserMenuIds(Long userId) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory.select(qdoMenu.id).from(qdoMenu)
                .leftJoin(qdoRoleMenu).on(qdoRoleMenu.menuId.longValue().eq(qdoMenu.id.longValue()))
                .leftJoin(qdoSysRole).on(qdoSysRole.id.eq(qdoRoleMenu.roleId))
                .leftJoin(qdoUserRole).on(qdoUserRole.roleId.eq(qdoSysRole.id));
        jpaQuery.where(qdoMenu.menuStatus.eq(0));
        jpaQuery.where(qdoMenu.deleteFlag.eq(0));
        jpaQuery.where(qdoSysRole.enabled.eq(true));
        jpaQuery.where(qdoSysRole.deleteFlag.eq(0));

        jpaQuery.where(qdoUserRole.userId.eq(userId));
        return jpaQuery.fetch();
    }
}
