package com.elitesland.tw.tw5.server.prd.my.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.TBusiCardApplyPayload;
import com.elitesland.tw.tw5.api.prd.my.query.TBusiCardApplyQuery;
import com.elitesland.tw.tw5.api.prd.my.vo.TBusiCardApplyVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.my.entity.QTBusiCardApplyDO;
import com.elitesland.tw.tw5.server.prd.my.entity.TBusiCardApplyDO;
import com.elitesland.tw.tw5.server.prd.my.repo.TBusiCardApplyRepo;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 名片申请
 *
 * @author lemon
 * @date 2023-09-11
 */
@Repository
@RequiredArgsConstructor
public class TBusiCardApplyDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final TBusiCardApplyRepo repo;
    private final QTBusiCardApplyDO qdo = QTBusiCardApplyDO.tBusiCardApplyDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<TBusiCardApplyVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(TBusiCardApplyVO.class,
                qdo.id,
                qdo.remark,
                //qdo.createUserId,
                //qdo.creator,
                //qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 英文名
//                qdo.eName,
                qdo.eName.as("englishName"),
                // BaseBU
                qdo.basebuId,
                // 所属公司
                qdo.ouId,
                // 手机号
                qdo.mobile,
                // 邮箱
                qdo.email,
                // 中文抬头
//                qdo.cTitle,
                qdo.cTitle.as("chineseTitle"),
                // 英文抬头
//                qdo.eTitle,
                qdo.eTitle.as("englishTitle"),
                // 邮件标志
                qdo.mailFlag,
                // 名片邮寄地址
                qdo.mailAddr,
                // 申请结果
                qdo.applyResult,
                // 取消原因
                qdo.cancelReason,
                // 申请人
                qdo.applyResId,
                // 申请日期
                qdo.applyDate,
                // 流程实例ID
                qdo.procInstId,
                // 流程审批状态
                qdo.procInstStatus,
                // 提交时间
                qdo.submitTime,
                // 审批时间
                qdo.approvedTime
        )).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<TBusiCardApplyVO> getJpaQueryWhere(TBusiCardApplyQuery query) {
        JPAQuery<TBusiCardApplyVO> jpaQuery = getJpaQuerySelect();
            // 条件封装
            jpaQuery.where(where(query));
            // 常用基础查询条件拼装
            SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
            // 动态排序
            jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
            return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(TBusiCardApplyQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
        .select(qdo.count())
        .from(qdo);
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(TBusiCardApplyQuery query){
        List<Predicate> list = new ArrayList<>();
        /** 记录唯一ID 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 英文名 精确 */
        if (!ObjectUtils.isEmpty(query.getEName())) {
            list.add(qdo.eName.eq(query.getEName()));
        }
        /** BaseBU 精确 */
        if (!ObjectUtils.isEmpty(query.getBasebuId())) {
            list.add(qdo.basebuId.eq(query.getBasebuId()));
        }
        /** 所属公司 精确 */
        if (!ObjectUtils.isEmpty(query.getOuId())) {
            list.add(qdo.ouId.eq(query.getOuId()));
        }
        /** 手机号 精确 */
        if (!ObjectUtils.isEmpty(query.getMobile())) {
            list.add(qdo.mobile.eq(query.getMobile()));
        }
        /** 邮箱 精确 */
        if (!ObjectUtils.isEmpty(query.getEmail())) {
            list.add(qdo.email.eq(query.getEmail()));
        }
        /** 中文抬头 精确 */
        if (!ObjectUtils.isEmpty(query.getCTitle())) {
            list.add(qdo.cTitle.eq(query.getCTitle()));
        }
        /** 英文抬头 精确 */
        if (!ObjectUtils.isEmpty(query.getETitle())) {
            list.add(qdo.eTitle.eq(query.getETitle()));
        }
        /** 邮件标志 精确 */
        if (!ObjectUtils.isEmpty(query.getMailFlag())) {
            list.add(qdo.mailFlag.eq(query.getMailFlag()));
        }
        /** 名片邮寄地址 精确 */
        if (!ObjectUtils.isEmpty(query.getMailAddr())) {
            list.add(qdo.mailAddr.eq(query.getMailAddr()));
        }
        /** 申请结果 精确 */
        if (!ObjectUtils.isEmpty(query.getApplyResult())) {
            list.add(qdo.applyResult.eq(query.getApplyResult()));
        }
        /** 取消原因 精确 */
        if (!ObjectUtils.isEmpty(query.getCancelReason())) {
            list.add(qdo.cancelReason.eq(query.getCancelReason()));
        }
        /** 申请人 精确 */
        if (!ObjectUtils.isEmpty(query.getApplyResId())) {
            list.add(qdo.applyResId.eq(query.getApplyResId()));
        }
        /** 申请日期 精确 */
        if (!ObjectUtils.isEmpty(query.getApplyDate())) {
            list.add(qdo.applyDate.eq(query.getApplyDate()));
        }
        /** 流程实例ID 精确 */
        if (!ObjectUtils.isEmpty(query.getProcInstId())) {
            list.add(qdo.procInstId.eq(query.getProcInstId()));
        }
        /** 流程审批状态 精确 */
        if (!ObjectUtils.isEmpty(query.getProcInstStatus())) {
            list.add(qdo.procInstStatus.eq(query.getProcInstStatus()));
        }
        /** 提交时间 精确 */
        if (!ObjectUtils.isEmpty(query.getSubmitTime())) {
            list.add(qdo.submitTime.eq(query.getSubmitTime()));
        }
        /** 审批时间 精确 */
        if (!ObjectUtils.isEmpty(query.getApprovedTime())) {
            list.add(qdo.approvedTime.eq(query.getApprovedTime()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public TBusiCardApplyVO queryByKey(Long id) {
        JPAQuery<TBusiCardApplyVO> jpaQuery = getJpaQuerySelect();
            jpaQuery.where(qdo.id.eq(id));
            jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<TBusiCardApplyVO> queryListDynamic(TBusiCardApplyQuery query) {
        JPAQuery<TBusiCardApplyVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<TBusiCardApplyVO> queryPaging(TBusiCardApplyQuery query) {
        long total = count(query);
        if (total == 0) {
             return PagingVO.empty();
        }
        JPAQuery<TBusiCardApplyVO> jpaQuery = getJpaQueryWhere(query);
        List<TBusiCardApplyVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<TBusiCardApplyVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public TBusiCardApplyDO save(TBusiCardApplyDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<TBusiCardApplyDO> saveAll(List<TBusiCardApplyDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(TBusiCardApplyPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
        .where(qdo.id.eq(payload.getId()));
        // 记录唯一ID
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 英文名
//        if (payload.getEName() != null) {
//            update.set(qdo.eName, payload.getEName());
//        }
        if (payload.getEnglishName() != null) {
            update.set(qdo.eName, payload.getEnglishName());
        }
        // BaseBU
        if (payload.getBasebuId() != null) {
            update.set(qdo.basebuId, payload.getBasebuId());
        }
        // 所属公司
        if (payload.getOuId() != null) {
            update.set(qdo.ouId, payload.getOuId());
        }
        // 手机号
        if (payload.getMobile() != null) {
            update.set(qdo.mobile, payload.getMobile());
        }
        // 邮箱
        if (payload.getEmail() != null) {
            update.set(qdo.email, payload.getEmail());
        }
        // 中文抬头
        if (payload.getChineseTitle() != null) {
            update.set(qdo.cTitle, payload.getChineseTitle());
        }
        // 英文抬头
        if (payload.getEnglishTitle() != null) {
            update.set(qdo.eTitle, payload.getEnglishTitle());
        }
        // 邮件标志
        if (payload.getMailFlag() != null) {
            update.set(qdo.mailFlag, payload.getMailFlag());
        }
        // 名片邮寄地址
        if (payload.getMailAddr() != null) {
            update.set(qdo.mailAddr, payload.getMailAddr());
        }
        // 申请结果
        if (payload.getApplyResult() != null) {
            update.set(qdo.applyResult, payload.getApplyResult());
        }
        // 取消原因
        if (payload.getCancelReason() != null) {
            update.set(qdo.cancelReason, payload.getCancelReason());
        }
        // 申请人
        if (payload.getApplyResId() != null) {
            update.set(qdo.applyResId, payload.getApplyResId());
        }
        // 申请日期
        if (payload.getApplyDate() != null) {
            update.set(qdo.applyDate, payload.getApplyDate());
        }
        // 流程实例ID
        if (payload.getProcInstId() != null) {
            update.set(qdo.procInstId, payload.getProcInstId());
        }
        // 流程审批状态
        if (payload.getProcInstStatus() != null) {
            update.set(qdo.procInstStatus, payload.getProcInstStatus());
        }
        // 提交时间
        if (payload.getSubmitTime() != null) {
            update.set(qdo.submitTime, payload.getSubmitTime());
        }
        // 审批时间
        if (payload.getApprovedTime() != null) {
            update.set(qdo.approvedTime, payload.getApprovedTime());
        }
        if (payload.getDeleteFlag() != null) {
            update.set(qdo.deleteFlag, payload.getDeleteFlag());
        }
        if (payload.getRemark() != null) {
            update.set(qdo.remark, payload.getRemark());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 记录唯一ID
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 英文名
            if (nullFields.contains("eName")) {
                update.setNull(qdo.eName);
            }
            // BaseBU
            if (nullFields.contains("basebuId")) {
                update.setNull(qdo.basebuId);
            }
            // 所属公司
            if (nullFields.contains("ouId")) {
                update.setNull(qdo.ouId);
            }
            // 手机号
            if (nullFields.contains("mobile")) {
                update.setNull(qdo.mobile);
            }
            // 邮箱
            if (nullFields.contains("email")) {
                update.setNull(qdo.email);
            }
            // 中文抬头
            if (nullFields.contains("cTitle")) {
                update.setNull(qdo.cTitle);
            }
            // 英文抬头
            if (nullFields.contains("eTitle")) {
                update.setNull(qdo.eTitle);
            }
            // 邮件标志
            if (nullFields.contains("mailFlag")) {
                update.setNull(qdo.mailFlag);
            }
            // 名片邮寄地址
            if (nullFields.contains("mailAddr")) {
                update.setNull(qdo.mailAddr);
            }
            // 申请结果
            if (nullFields.contains("applyResult")) {
                update.setNull(qdo.applyResult);
            }
            // 取消原因
            if (nullFields.contains("cancelReason")) {
                update.setNull(qdo.cancelReason);
            }
            // 申请人
            if (nullFields.contains("applyResId")) {
                update.setNull(qdo.applyResId);
            }
            // 申请日期
            if (nullFields.contains("applyDate")) {
                update.setNull(qdo.applyDate);
            }
            // 流程实例ID
            if (nullFields.contains("procInstId")) {
                update.setNull(qdo.procInstId);
            }
            // 流程审批状态
            if (nullFields.contains("procInstStatus")) {
                update.setNull(qdo.procInstStatus);
            }
            // 提交时间
            if (nullFields.contains("submitTime")) {
                update.setNull(qdo.submitTime);
            }
            // 审批时间
            if (nullFields.contains("approvedTime")) {
                update.setNull(qdo.approvedTime);
            }
            if (nullFields.contains("deleteFlag")) {
                update.setNull(qdo.deleteFlag);
            }
            if (nullFields.contains("remark")) {
                update.setNull(qdo.remark);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
            .set(qdo.deleteFlag, 1)
            .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

}

