package com.elitesland.tw.tw5.server.prd.my.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.time.LocalDate;

@Entity
@Table(name = "t_attendance_normal", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "t_attendance_normal", comment = "正常上下班打卡表 1个资源1天只有1条打卡记录")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class TAttendanceNormalDO extends BaseModel {


    @Comment("打卡人员ID")
    @Column()
    private Long attendanceResId;

    @Comment("规则ID")
    @Column()
    private Long attendanceRuleId;

    @Comment("打卡日期")
    @Column()
    private LocalDate attendanceDate;

    @Comment("上班时间")
    @Column()
    private String attendanceTimeStart;

    @Comment("下班时间")
    @Column()
    private String attendanceTimeEnd;

    @Comment("打卡经度")
    @Column()
    private String attendanceSiteLongitude;

    @Comment("打卡纬度")
    @Column()
    private String attendanceSiteLatitude;

    @Comment("打卡位置")
    @Column()
    private String attendanceLocation;

    @Comment("打卡城市")
    @Column()
    private String attendanceCity;

    @Comment("打卡结果 YSE/NO")
    @Column()
    private String attendanceResult;

    @Comment("正常、迟到或早退、矿工")
    @Column()
    private String attendanceResultDetail;

    @Comment("特殊打卡原因")
    @Column()
    private String specialReason;

    @Comment("打卡设备")
    @Column()
    private String attendanceDevice;

    @Comment("是否冻结(0未冻结1冻结)")
    @Column()
    private Integer frozen;

    @Comment("4.0主键id")
    @Column(name = "attendance_normal_id_v4")
    private Long attendanceNormalIdV4;

    public void copy(TAttendanceNormalDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
