package com.elitesland.tw.tw5.server.prd.my.repo;

import com.elitesland.tw.tw5.server.prd.my.entity.UserVacationApplyDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @author sunxw
 * @description 用户请假申请
 * @Date 2023/5/9
 */
@Transactional
public interface UserVacationApplyRepo extends JpaRepository<UserVacationApplyDO, Long>, JpaSpecificationExecutor<UserVacationApplyDO> {

    /**
     * 根据idV4List查询当前表中记录
     *
     * @param tw4UserVacationApplyIds
     * @return 此处使用select *是因jpa别名会报错
     */
    @Query(value = "select * from t_user_vacation_apply a where apply_id_v4 in (?1)", nativeQuery = true)
    List<UserVacationApplyDO> selectByIdV4List(List<Long> tw4UserVacationApplyIds);

    /**
     * 根据idV4查询当前表中记录
     *
     * @param applyIdV4
     * @return
     */
    @Query(value = "select * from t_user_vacation_apply where apply_id_v4 = ?1", nativeQuery = true)
    UserVacationApplyDO selectByIdV4(Long applyIdV4);

    UserVacationApplyDO findByProcInstId(String procId);
}
