package com.elitesland.tw.tw5.server.prd.my.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.TaskAuthorizedDetailsPayload;
import com.elitesland.tw.tw5.api.prd.my.query.TaskAuthorizedDetailsQuery;
import com.elitesland.tw.tw5.api.prd.my.service.TaskAuthorizedDetailsService;
import com.elitesland.tw.tw5.api.prd.my.vo.TaskAuthorizedDetailsVO;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.util.FileUtil;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.prd.my.convert.TaskAuthorizedDetailsConvert;
import com.elitesland.tw.tw5.server.prd.my.entity.TaskAuthorizedDetailsDO;
import com.elitesland.tw.tw5.server.prd.my.repo.TaskAuthorizedDetailsRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.*;

/**
 * 任务包授权主表
 *
 * @author duwh
 * @date 2022-12-16
 */
@Service
@RequiredArgsConstructor
@Slf4j
@Deprecated
public class TaskAuthorizedDetailsServiceImpl implements TaskAuthorizedDetailsService {

    private final TaskAuthorizedDetailsRepo taskAuthorizedDetailsRepo;

    @Override
    public PagingVO<TaskAuthorizedDetailsVO> paging(TaskAuthorizedDetailsQuery query) {
        Page<TaskAuthorizedDetailsDO> page = taskAuthorizedDetailsRepo.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder), query.getPageRequest());
        return PageUtil.toPageVo(page.map(TaskAuthorizedDetailsConvert.INSTANCE::toVo));
    }

    @Override
    public List<TaskAuthorizedDetailsVO> queryList(TaskAuthorizedDetailsQuery query) {
        return TaskAuthorizedDetailsConvert.INSTANCE.toVoList(taskAuthorizedDetailsRepo.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder)));
    }

    @Override
    public TaskAuthorizedDetailsVO queryByKey(Long key) {
        TaskAuthorizedDetailsDO entity = taskAuthorizedDetailsRepo.findById(key).orElseGet(TaskAuthorizedDetailsDO::new);
        Assert.notNull(entity.getId(), "不存在");
        TaskAuthorizedDetailsVO vo = TaskAuthorizedDetailsConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public TaskAuthorizedDetailsVO insert(TaskAuthorizedDetailsPayload payload) {
        TaskAuthorizedDetailsDO entityDo = TaskAuthorizedDetailsConvert.INSTANCE.toDo(payload);
        return TaskAuthorizedDetailsConvert.INSTANCE.toVo(taskAuthorizedDetailsRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public TaskAuthorizedDetailsVO update(TaskAuthorizedDetailsPayload payload) {
        TaskAuthorizedDetailsDO entity = taskAuthorizedDetailsRepo.findById(payload.getId()).orElseGet(TaskAuthorizedDetailsDO::new);
        Assert.notNull(entity.getId(), "不存在");
        TaskAuthorizedDetailsDO entityDo = TaskAuthorizedDetailsConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return TaskAuthorizedDetailsConvert.INSTANCE.toVo(taskAuthorizedDetailsRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            taskAuthorizedDetailsRepo.deleteSoft(keys);
        }
    }

    @Override
    public void download(List<TaskAuthorizedDetailsVO> all, HttpServletResponse response) throws IOException {
        List<Map<String, Object>> list = new ArrayList<>();
        for (TaskAuthorizedDetailsVO taskAuthorizedDetails : all) {
            Map<String, Object> map = new LinkedHashMap<>();
            map.put("授权主键 t_task_authorized.id", taskAuthorizedDetails.getAuthId());
            map.put("授权主键 t_task_authorized.id", taskAuthorizedDetails.getAuthIdV5());
            map.put("任务id", taskAuthorizedDetails.getTaskId());
            map.put("任务id", taskAuthorizedDetails.getTaskIdV5());
            map.put("接收资源resid", taskAuthorizedDetails.getReceiverResId());
            map.put("接收资源userId v5", taskAuthorizedDetails.getReceiverUserId());
            map.put("接收资源buid", taskAuthorizedDetails.getReceiverBuId());
            map.put("接收资源buid", taskAuthorizedDetails.getReceiverOrgId());
            list.add(map);
        }
        FileUtil.downloadExcel(list, response);
    }
}
