package com.elitesland.tw.tw5.server.prd.partner.business.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * 业务合作伙伴-年报网址
 *
 * @author wangly
 * @date 2023-05-18
 */
@Entity
@Table(name = "com_business_operation_sites", indexes = {
        @Index(name = "partner_id_index", columnList = "partner_id")
})
@org.hibernate.annotations.Table(appliesTo = "com_business_operation_sites", comment = "业务合作伙伴-年报网址")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class BusinessOperationSitesDO extends BaseModel implements Serializable  {
    /** 地址簿id */
    @Comment("地址簿id")
    @Column()
    private Long bookId;
    /** 审核时间 */
    @Comment("审核时间")
    @Column()
    private String date;
    /** 网址 */
    @Comment("网址")
    @Column()
    private String url;
    /** 企业网址名称 */
    @Comment("企业网址名称")
    @Column()
    private String name;
    /** 网址类型 */
    @Comment("网址类型")
    @Column()
    private String type;
    /** 业务伙伴主键 business_partner.id */
    @Comment("业务伙伴主键 business_partner.id")
    @Column(name="partner_id")
    private Long partnerId;
    /** 业务伙伴名称 */
    @Comment("业务伙伴名称")
    @Column(name="partner_name")
    private String partnerName;

    public void copy(BusinessOperationSitesDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
