package com.elitesland.tw.tw5.server.prd.partner.common.controller;

import com.elitesland.tw.tw5.api.prd.partner.common.payload.BookLicensePayload;
import com.elitesland.tw.tw5.api.prd.partner.common.query.BookLicenseQuery;
import com.elitesland.tw.tw5.api.prd.partner.common.service.BookLicenseService;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BookLicenseVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 公司主体-证件信息
 *
 * @author wangly
 * @date 2023-05-29
 */
@Api(tags = "公司主体-证件信息")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/bookLicense")
@Slf4j
public class BookLicenseController {

    private final BookLicenseService bookLicenseService;

    /**
     * 公司主体-证件信息-新增
     *

     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("公司主体-证件信息-新增")
    public TwOutputUtil insert(@RequestBody BookLicensePayload payload){
        return TwOutputUtil.ok(bookLicenseService.insert(payload));
    }

    /**
     * 公司主体-证件信息-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("公司主体-证件信息-更新")
    public TwOutputUtil update(@RequestBody BookLicensePayload payload){
        return TwOutputUtil.ok(bookLicenseService.update(payload));
    }

    /**
     * 公司主体-证件信息-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
//    @GetMapping("/{key}")
//    // @UdcNameClass
//    @ApiOperation("公司主体-证件信息-主键查询")
//    public TwOutputUtil<BookLicenseVO> queryOneByKey(@PathVariable Long key) {
//        return TwOutputUtil.ok(bookLicenseService.queryByKey(key));
//    }

    /**
     * 公司主体-证件信息-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
//    @GetMapping("/paging")
//    @UdcNameClass
//    @ApiOperation("公司主体-证件信息-分页")
//    public TwOutputUtil<PagingVO<BookLicenseVO>> paging(BookLicenseQuery query) {
//        return TwOutputUtil.ok(bookLicenseService.queryPaging(query));
//    }

    /**
     * 公司主体-证件信息-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    @UdcNameClass
    @ApiOperation("公司主体-证件信息-查询列表")
    public TwOutputUtil<List<BookLicenseVO>> queryList(BookLicenseQuery query) {
        return TwOutputUtil.ok(bookLicenseService.queryListDynamic(query));
    }

    /**
     * 公司主体-证件信息-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("公司主体-证件信息-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        bookLicenseService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}
