package com.elitesland.tw.tw5.server.prd.partner.common.repo;

import com.elitesland.tw.tw5.server.prd.partner.common.entity.BusinessPartnerDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;

import java.util.List;

/**
 * 业务伙伴管理
 *
 * @author wangluyu
 * @date 2023-05-16
 */
public interface BusinessPartnerRepo extends JpaRepository<BusinessPartnerDO, Long>, JpaSpecificationExecutor<BusinessPartnerDO> {
    /**
     * 通过业务伙伴名称查询
     * @param partnerName
     *
     * @return List<BusinessPartnerDO> do集合
     */
    List<BusinessPartnerDO> findByPartnerName(String partnerName);

    @Query(value = "SELECT count(id) FROM sale_con_contract WHERE CUST_ID=(select book_id from com_business_partner where id=?1 AND delete_flag=0) AND delete_flag=0 AND main_type='SUB'",nativeQuery = true)
    int queryContractNum(Long customerId);
}
