package com.elitesland.tw.tw5.server.prd.partner.common.service;

import cn.hutool.extra.spring.SpringUtil;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.partner.common.payload.BookInvoicePayload;
import com.elitesland.tw.tw5.api.prd.partner.common.query.BookInvoiceQuery;
import com.elitesland.tw.tw5.api.prd.partner.common.service.BookInvoiceService;
import com.elitesland.tw.tw5.api.prd.partner.common.service.BusinessPartnerService;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BookInvoiceVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.util.ChangeFieldLogUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemObjectEnum;
import com.elitesland.tw.tw5.server.prd.partner.common.convert.BookInvoiceConvert;
import com.elitesland.tw.tw5.server.prd.partner.common.dao.BookInvoiceDAO;
import com.elitesland.tw.tw5.server.prd.partner.common.entity.BookInvoiceDO;
import com.elitesland.tw.tw5.server.prd.partner.common.repo.BookInvoiceRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 业务伙伴-发票信息
 *
 * @author wangly
 * @date 2023-05-16
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class BookInvoiceServiceImpl extends BaseServiceImpl implements BookInvoiceService {

    private final BookInvoiceRepo bookInvoiceRepo;
    private final BookInvoiceDAO bookInvoiceDAO;
    private final PrdSystemLogService logService;
    private final ChangeFieldLogUtil changeFieldLogUtil;

    @Override
    public PagingVO<BookInvoiceVO> queryPaging(BookInvoiceQuery query){
        return bookInvoiceDAO.queryPaging(query);
    }

    @Override
    public List<BookInvoiceVO> queryListDynamic(BookInvoiceQuery query){
        return bookInvoiceDAO.queryListDynamic(query);
    }

    @Override
    public BookInvoiceVO queryByKey(Long key) {
        BookInvoiceDO entity = bookInvoiceRepo.findById(key).orElseGet(BookInvoiceDO::new);
        Assert.notNull(entity.getId(), "不存在");
        BookInvoiceVO vo = BookInvoiceConvert.INSTANCE.toVo(entity);
        return vo;
    }

    /**
     * 根据bookId查询默认
     *
     * @param bookId bookId
     * @return {@link BookInvoiceVO}
     */
    @Override
    public BookInvoiceVO queryDefaultByBookId(Long bookId) {
        return bookInvoiceDAO.queryDefaultByBookId(bookId);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BookInvoiceVO insert(BookInvoicePayload payload,Boolean logFlag) {
        //如果默认值是true就将原来的默认数据置为false
        if(payload!=null && payload.getIsDefault()){
            List<BookInvoiceDO> defaultDOs = bookInvoiceRepo.findByBookIdAndIsDefault(payload.getBookId(), true);
            /**
             * 当默认值存在的时候，将默认值设置未否
             */
            if(!CollectionUtils.isEmpty(defaultDOs)){
                for (BookInvoiceDO defaultDO : defaultDOs) {
                    defaultDO.setIsDefault(false);
                    bookInvoiceRepo.save(defaultDO);
                }
            }
        }
//        else {
//            payload.setIsDefault(true);
//        }
//        if(payload.getIsDefault()!=null&&payload.getIsDefault()&&!CollectionUtils.isEmpty(defaultDOs)){
//            for (BookInvoiceDO defaultDO : defaultDOs) {
//                defaultDO.setIsDefault(false);
//                bookInvoiceRepo.save(defaultDO);
//            }
//        }
        //空 说明是新增的第一条 新增的第一条置为默认
//        if(defaultDO==null){
//            payload.setIsDefault(true);
//        }
        BookInvoiceDO entityDo = BookInvoiceConvert.INSTANCE.toDo(payload);
        //操作记录
        if(logFlag&&payload.getPartnerId()!=null){
            // 获取变更日志
            //            final String fieldsCreateLog = changeFieldLogUtil.getFieldsCreateLog(entityDo);
            //            logService.saveNewLog(payload.getPartnerId(), PrdSystemObjectEnum.BUSINESS_PARTNER.getCode(), fieldsCreateLog);
            logService.saveNewLog(payload.getPartnerId(), PrdSystemObjectEnum.BUSINESS_PARTNER.getCode(), "新增了一条开票信息");

        }
        //更新业务伙伴的更新时间 方便数据同步到4.0
        BusinessPartnerService businessPartnerService = SpringUtil.getBean(BusinessPartnerService.class);
        businessPartnerService.updateBusinessParnerModifyTime(Collections.singletonList(payload.getBookId()));
        return BookInvoiceConvert.INSTANCE.toVo(bookInvoiceRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void batchInsert(List<BookInvoiceVO> voList) {
        //批量插入的时候要注意先删除表中其他数据 只适用于全删全插
        if(!CollectionUtils.isEmpty(voList)){
            List<BookInvoiceVO> collect = voList.stream().filter(p -> p.getIsDefault()!=null && p.getIsDefault().equals(true)).collect(Collectors.toList());
            //当插入的数据没有默认的时候 选一个默认给他
            if (CollectionUtils.isEmpty(collect)) {
                collect.stream().forEach(p -> p.setIsDefault(false));
                voList.get(0).setIsDefault(true);
            } else {
                if (collect.size() > 1) {
                    throw TwException.error("", "发票信息不能提交多条默认的数据");
                }
                //将不是默认的数据捞出来 然后置为false(前端传过来的时候是空 所以要给值)
                List<BookInvoiceVO> collectFalse = voList.stream().filter(p -> p.getIsDefault() == null || !p.getIsDefault()).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(collectFalse)) {
                    collectFalse.stream().forEach(p -> p.setIsDefault(false));
                }
            }
            List<BookInvoiceDO> bookInvoiceDOS = BookInvoiceConvert.INSTANCE.toEntity(voList);
            bookInvoiceRepo.saveAll(bookInvoiceDOS);
            //更新业务伙伴的更新时间 方便数据同步到4.0
            BusinessPartnerService businessPartnerService = SpringUtil.getBean(BusinessPartnerService.class);
            businessPartnerService.updateBusinessParnerModifyTime(Collections.singletonList(voList.get(0).getBookId()));
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BookInvoiceVO update(BookInvoicePayload payload,Boolean logFlag) {
        BookInvoiceDO entity = bookInvoiceRepo.findById(payload.getId()).orElseGet(BookInvoiceDO::new);
        Assert.notNull(entity.getId(), "不存在");
        // 变更日志用
        //        BookInvoiceDO entityLog = new BookInvoiceDO();
        //        BeanUtils.copyProperties(entity, entityLog);
        //如果默认值是true就将原来的默认数据置为false
        if(payload!=null && payload.getIsDefault()){
            List<BookInvoiceDO> defaultDOs = bookInvoiceRepo.findByBookIdAndIsDefault(payload.getBookId(), true);
            /**
             * 当默认值存在的时候，将默认值设置未否
             */
            if(!CollectionUtils.isEmpty(defaultDOs)){
                for (BookInvoiceDO defaultDO : defaultDOs) {
                    defaultDO.setIsDefault(false);
                    bookInvoiceRepo.save(defaultDO);
                }
            }
        }
        BookInvoiceDO entityDo = BookInvoiceConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        //操作记录
        if (logFlag && null != payload.getPartnerId()) {
            logService.saveNewLog(payload.getPartnerId(), PrdSystemObjectEnum.BUSINESS_PARTNER.getCode(), "修改了一条开票信息");
        }
        //        //操作记录
        //        if (logFlag&&null != payload.getPartnerId()) {
        //            // 修改NULL值特殊处理
        //            final StringBuilder fieldsUpdateLog = changeFieldLogUtil.nullFieldsProcess(payload, entityLog, entity);
        //            //获取变更日志
        //            fieldsUpdateLog.append(changeFieldLogUtil.getFieldsUpdateLog(entityDo, entityLog));
        //            if (org.springframework.util.StringUtils.hasText(fieldsUpdateLog)) {
        //                logService.saveNewLog(payload.getPartnerId(), PrdSystemObjectEnum.BUSINESS_PARTNER.getCode(), fieldsUpdateLog.toString());
        //            }
        //            //  logService.saveNewLog(payload.getPartnerId(), PrdSystemObjectEnum.BUSINESS_PARTNER.getCode(), "更改账户信息");
        //        }
        //todo wly
        //更新业务伙伴的更新时间 方便数据同步到4.0
        BusinessPartnerService businessPartnerService = SpringUtil.getBean(BusinessPartnerService.class);
        businessPartnerService.updateBusinessParnerModifyTime(Collections.singletonList(entity.getBookId()));
        return BookInvoiceConvert.INSTANCE.toVo(bookInvoiceRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys,Long bookId,Long partnerId,Boolean logFlag) {
        if (!keys.isEmpty()) {
            BookInvoiceVO bookInvoiceVO = bookInvoiceDAO.queryByKey(keys.get(0));
            Long boookId = bookInvoiceVO.getBookId();
            bookInvoiceDAO.deleteSoft(keys);
            //如果删除只剩最后一条 就设为默认地址
            List<BookInvoiceDO> dos = bookInvoiceDAO.queryByBookId(boookId);
            if(dos!=null&&dos.size()==1){
                BookInvoiceDO bookInvoiceDO = dos.get(0);
                bookInvoiceDO.setIsDefault(true);
                bookInvoiceRepo.save(bookInvoiceDO);
            }
            if(logFlag){
                logService.saveNewLog(partnerId, PrdSystemObjectEnum.BUSINESS_PARTNER.getCode(), "删除了 "+keys.size()+" 条开票信息");
            }
            //更新业务伙伴的更新时间 方便数据同步到4.0
            BusinessPartnerService businessPartnerService = SpringUtil.getBean(BusinessPartnerService.class);
            businessPartnerService.updateBusinessParnerModifyTime(Collections.singletonList(bookId));
        }
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoftBykeys(List<Long> keys,Long bookId,Long partnerId) {
        if (!keys.isEmpty()) {
            bookInvoiceDAO.deleteSoft(keys);
            logService.saveNewLog(partnerId, PrdSystemObjectEnum.BUSINESS_PARTNER.getCode(), "删除了 "+keys.size()+" 条开票信息");
            //更新业务伙伴的更新时间 方便数据同步到4.0
            BusinessPartnerService businessPartnerService = SpringUtil.getBean(BusinessPartnerService.class);
            businessPartnerService.updateBusinessParnerModifyTime(Collections.singletonList(bookId));
        }
    }
    @Override
    public Long count(BookInvoiceQuery query) {
        return bookInvoiceDAO.count(query);
    }

    @Override
    @Transactional
    public void deleteByBookId(Long bookId) {
        bookInvoiceDAO.deleteByBookId(bookId);
        //更新业务伙伴的更新时间 方便数据同步到4.0
        BusinessPartnerService businessPartnerService = SpringUtil.getBean(BusinessPartnerService.class);
        businessPartnerService.updateBusinessParnerModifyTime(Collections.singletonList(bookId));
    }

//    @Override
//    public List<PrdAbInvoicePayload> queryTwBookInvoiceListByBookId(List<Long> bookIdList) {
//        return bookInvoiceDAO.queryTwBookInvoiceListByBookId(bookIdList);
//    }
    @Override
    @Transactional
    public void saveAll(List<BookInvoiceVO> bookInvoiceVOList) {
        bookInvoiceDAO.saveAll(BookInvoiceConvert.INSTANCE.toEntity(bookInvoiceVOList));
    }
}
