package com.elitesland.tw.tw5.server.prd.partner.common.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitesland.tw.tw5.api.prd.partner.common.payload.BookLicensePayload;
import com.elitesland.tw.tw5.api.prd.partner.common.query.BookLicenseQuery;
import com.elitesland.tw.tw5.api.prd.partner.common.service.BookLicenseService;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BookLicenseVO;
import com.elitesland.tw.tw5.server.prd.partner.common.convert.BookLicenseConvert;
import com.elitesland.tw.tw5.server.prd.partner.common.dao.BookLicenseDAO;
import com.elitesland.tw.tw5.server.prd.partner.common.entity.BookLicenseDO;
import com.elitesland.tw.tw5.server.prd.partner.common.repo.BookLicenseRepo;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.List;
import java.util.Optional;

/**
 * 公司主体-证件信息
 *
 * @author wangly
 * @date 2023-05-29
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class BookLicenseServiceImpl extends BaseServiceImpl implements BookLicenseService {

    private final BookLicenseRepo bookLicenseRepo;
    private final BookLicenseDAO bookLicenseDAO;
    private final FileUtil fileUtil;
    @Override
    public PagingVO<BookLicenseVO> queryPaging(BookLicenseQuery query){
        PagingVO<BookLicenseVO> bookLicenseVOPagingVO = bookLicenseDAO.queryPaging(query);
        bookLicenseVOPagingVO.stream().forEach(vo->vo.setFileData(fileUtil.getFileDatas(vo.getFileCode())));
        return bookLicenseVOPagingVO;
    }

    @Override
    public List<BookLicenseVO> queryListDynamic(BookLicenseQuery query){
        List<BookLicenseVO> bookLicenseVOS = bookLicenseDAO.queryListDynamic(query);
        if(bookLicenseVOS!=null&&bookLicenseVOS.size()>0){
            bookLicenseVOS.stream().forEach(vo->vo.setFileData(fileUtil.getFileDatas(vo.getFileCode())));
        }
        return bookLicenseVOS;
    }

    @Override
    public BookLicenseVO queryByKey(Long key) {
        BookLicenseDO entity = bookLicenseRepo.findById(key).orElseGet(BookLicenseDO::new);
        Assert.notNull(entity.getId(), "不存在");
        BookLicenseVO vo = BookLicenseConvert.INSTANCE.toVo(entity);
        vo.setFileData(fileUtil.getFileDatas(vo.getFileCode()));
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BookLicenseVO insert(BookLicensePayload payload) {
        BookLicenseDO entityDo = BookLicenseConvert.INSTANCE.toDo(payload);
        return BookLicenseConvert.INSTANCE.toVo(bookLicenseRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BookLicenseVO update(BookLicensePayload payload) {
        BookLicenseDO entity = bookLicenseRepo.findById(payload.getId()).orElseGet(BookLicenseDO::new);
        Assert.notNull(entity.getId(), "不存在");
        BookLicenseDO entityDo = BookLicenseConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return BookLicenseConvert.INSTANCE.toVo(bookLicenseRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            bookLicenseDAO.deleteSoft(keys);
        }
    }

}
