package com.elitesland.tw.tw5.server.prd.partner.strategy.controller;

import com.elitesland.tw.tw5.api.prd.partner.strategy.query.BusinessStrategyIndexRecordQuery;
import com.elitesland.tw.tw5.api.prd.partner.strategy.service.BusinessStrategyIndexRecordService;
import com.elitesland.tw.tw5.api.prd.partner.strategy.vo.BusinessStrategyIndexRecordVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 分级策略-分级记录
 *
 * @folder 分级策略分级记录
 * @author wangly
 * @date 2023-06-28
 */
@Api(tags = "分级策略-分级记录")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/businessStrategyIndexRecord")
@Slf4j
public class BusinessStrategyIndexRecordController {

private final BusinessStrategyIndexRecordService businessStrategyIndexRecordService;

//    /**
//     * 分级策略-分级记录-新增
//     *
//     * @folder 分级策略分级记录
//     * @param payload 有效载荷
//     * @return {@link TwOutputUtil}
//     */
//    @PostMapping
//    @ApiOperation("分级策略-分级记录-新增")
//    public TwOutputUtil<BusinessStrategyIndexRecordVO> insert(@RequestBody BusinessStrategyIndexRecordPayload payload){
//         return TwOutputUtil.ok(businessStrategyIndexRecordService.insert(payload));
//    }

//    /**
//     * 分级策略-分级记录-更新
//     *
//         * @folder 分级策略分级记录
//     * @param payload 有效载荷
//     * @return {@link TwOutputUtil}
//     */
//    @PutMapping
//    @ApiOperation("分级策略-分级记录-更新")
//    public TwOutputUtil<BusinessStrategyIndexRecordVO> update(@RequestBody BusinessStrategyIndexRecordPayload payload){
//        return TwOutputUtil.ok(businessStrategyIndexRecordService.update(payload));
//    }

//    /**
//     * 分级策略-分级记录-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
//     *
//     * @folder 分级策略分级记录
//     * @param payload 有效载荷
//     * @return {@link TwOutputUtil}
//     */
//    @PutMapping("update")
//    @ApiOperation("分级策略-分级记录-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
//    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody BusinessStrategyIndexRecordPayload payload){
//        return TwOutputUtil.ok(businessStrategyIndexRecordService.updateByKeyDynamic(payload));
//    }

//    /**
//     * 分级策略-分级记录-主键查询
//     *
//     * @folder 分级策略分级记录
//     * @param key 关键
//     * @return {@link TwOutputUtil}
//     */
//    @GetMapping("/{key}")
//    // @UdcNameClass
//    @ApiOperation("分级策略-分级记录-主键查询")
//    public TwOutputUtil<BusinessStrategyIndexRecordVO> queryOneByKey(@PathVariable Long key) {
//        return TwOutputUtil.ok(businessStrategyIndexRecordService.queryByKey(key));
//    }

//    /**
//     * 分级策略-分级记录-分页
//     *
//         * @folder 分级策略分级记录
//     * @param query 查询
//     * @return {@link TwOutputUtil}
//     */
//    @GetMapping("/paging")
//    // @UdcNameClass
//    @ApiOperation("分级策略-分级记录-分页")
//    public TwOutputUtil<PagingVO<BusinessStrategyIndexRecordVO>> paging(BusinessStrategyIndexRecordQuery query) {
//        return TwOutputUtil.ok(businessStrategyIndexRecordService.queryPaging(query));
//    }

    /**
     * 分级策略-分级记录-查询列表
     *
     * @folder 分级策略分级记录
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("分级策略-分级记录-查询列表")
    public TwOutputUtil<List<BusinessStrategyIndexRecordVO>> queryList(BusinessStrategyIndexRecordQuery query) {
        return TwOutputUtil.ok(businessStrategyIndexRecordService.queryListDynamic(query));
    }

//    /**
//     * 分级策略-分级记录-删除
//     *
//         * @folder 分级策略分级记录
//     * @param keys 主键id
//     * @return result
//     */
//    @DeleteMapping("/deleteSoft")
//    @ApiOperation("分级策略-分级记录-删除")
//    public TwOutputUtil deleteSoft(Long[] keys) {
//         businessStrategyIndexRecordService.deleteSoft(Arrays.asList(keys));
//        return TwOutputUtil.ok();
//    }

    /**
     * 分级策略-分级记录-查询本次的记录
     *
     * @folder 查询本次的记录
     * @param customerId 客户id
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/queryListByCustomerId")
    // @UdcNameClass
    @ApiOperation("分级策略-分级记录-查询本次的记录")
    public TwOutputUtil<List<BusinessStrategyIndexRecordVO>> queryListByCustomerId(Long customerId) {
        return TwOutputUtil.ok(businessStrategyIndexRecordService.queryListByCustomerId(customerId));
    }

}

