package com.elitesland.tw.tw5.server.prd.partner.strategy.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.partner.strategy.payload.BusinessStrategyRangeSettingPayload;
import com.elitesland.tw.tw5.api.prd.partner.strategy.query.BusinessStrategyRangeSettingQuery;
import com.elitesland.tw.tw5.api.prd.partner.strategy.service.BusinessStrategyRangeSettingService;
import com.elitesland.tw.tw5.api.prd.partner.strategy.vo.BusinessStrategyRangeSettingVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 分级策略范围配置
 *
 * @folder 分级策略-范围配置
 * @author wangly
 * @date 2023-06-16
 */
@Api(tags = "分级策略范围配置")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/businessStrategyRangeSetting")
@Slf4j
public class BusinessStrategyRangeSettingController {

private final BusinessStrategyRangeSettingService businessStrategyRangeSettingService;

    /**
     * 分级策略范围配置-新增
     *
     * @folder 分级策略-范围配置
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("分级策略范围配置-新增")
    public TwOutputUtil<BusinessStrategyRangeSettingVO> insert(@RequestBody BusinessStrategyRangeSettingPayload payload){
         return TwOutputUtil.ok(businessStrategyRangeSettingService.insert(payload));
    }

    /**
     * 分级策略范围配置-更新
     *
         * @folder 分级策略-范围配置
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("分级策略范围配置-更新")
    public TwOutputUtil<BusinessStrategyRangeSettingVO> update(@RequestBody BusinessStrategyRangeSettingPayload payload){
        return TwOutputUtil.ok(businessStrategyRangeSettingService.update(payload));
    }

    /**
     * 分级策略范围配置-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @folder 分级策略-范围配置
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("分级策略范围配置-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody BusinessStrategyRangeSettingPayload payload){
        return TwOutputUtil.ok(businessStrategyRangeSettingService.updateByKeyDynamic(payload));
    }

    /**
     * 分级策略范围配置-主键查询
     *
     * @folder 分级策略-范围配置
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("分级策略范围配置-主键查询")
    public TwOutputUtil<BusinessStrategyRangeSettingVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(businessStrategyRangeSettingService.queryByKey(key));
    }

    /**
     * 分级策略范围配置-分页
     *
         * @folder 分级策略-范围配置
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("分级策略范围配置-分页")
    public TwOutputUtil<PagingVO<BusinessStrategyRangeSettingVO>> paging(BusinessStrategyRangeSettingQuery query) {
        return TwOutputUtil.ok(businessStrategyRangeSettingService.queryPaging(query));
    }

    /**
     * 分级策略范围配置-查询列表
     *
     * @folder 分级策略-范围配置
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("分级策略范围配置-查询列表")
    public TwOutputUtil<List<BusinessStrategyRangeSettingVO>> queryList(BusinessStrategyRangeSettingQuery query) {
        return TwOutputUtil.ok(businessStrategyRangeSettingService.queryListDynamic(query));
    }

    /**
     * 分级策略范围配置-删除
     *
         * @folder 分级策略-范围配置
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("分级策略范围配置-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
         businessStrategyRangeSettingService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}

