package com.elitesland.tw.tw5.server.prd.partner.strategy.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * 分级策略业务伙伴映射关系
 *
 * @author wanlgy
 * @date 2023-06-19
 */
@Entity
@Table(name = "business_strategy_ref", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "business_strategy_ref", comment = "分级策略业务伙伴映射关系")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class BusinessStrategyRefDO extends BaseModel implements Serializable  {
    /** 分级策略id business_strategy.id */
    @Comment("分级策略id business_strategy.id")
    @Column()
    private Long strategyId;
    /** 业务伙伴id business_partner.id */
    @Comment("业务伙伴id business_partner.id")
    @Column()
    private Long partnerId;
    /** 选项分数 */
    @Comment("选项分数")
    @Column()
    private Integer optionScore;
    /** 排序号 */
    @Comment("排序号")
    @Column()
    private Integer sortNo;
    /** 拓展字段1 */
    @Comment("拓展字段1")
    @Column()
    private String ext1;
    /** 拓展字段2 */
    @Comment("拓展字段2")
    @Column()
    private String ext2;
    /** 拓展字段3 */
    @Comment("拓展字段3")
    @Column()
    private String ext3;
    /** 拓展字段4 */
    @Comment("拓展字段4")
    @Column()
    private String ext4;
    /** 拓展字段5 */
    @Comment("拓展字段5")
    @Column()
    private String ext5;

    public void copy(BusinessStrategyRefDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
