package com.elitesland.tw.tw5.server.prd.personplan.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.personplan.payload.PersonPlanVersionPayload;
import com.elitesland.tw.tw5.api.prd.personplan.query.PersonPlanVersionQuery;
import com.elitesland.tw.tw5.api.prd.personplan.service.PersonPlanVersionService;
import com.elitesland.tw.tw5.api.prd.personplan.vo.PersonPlanVersionVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 人员规划版本
 *
 * @folder 人员规划版本
 * @author wangly
 * @date 2024-04-07
 */
@Api(tags = "人员规划版本")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/personPlanVersion")
@Slf4j
public class PersonPlanVersionController {

private final PersonPlanVersionService personPlanVersionService;

    /**
     * 人员规划版本-新增
     *
     * @folder 人员规划版本
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("人员规划版本-新增")
    public TwOutputUtil insert(@RequestBody PersonPlanVersionPayload payload){
         return TwOutputUtil.ok(personPlanVersionService.save(payload));
    }

    /**
     * 人员规划版本-更新
     *
         * @folder 人员规划版本
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("人员规划版本-更新")
    public TwOutputUtil<PersonPlanVersionVO> update(@RequestBody PersonPlanVersionPayload payload){
        return TwOutputUtil.ok(personPlanVersionService.update(payload));
    }

    /**
     * 人员规划版本-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @folder 人员规划版本
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("人员规划版本-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody PersonPlanVersionPayload payload){
        return TwOutputUtil.ok(personPlanVersionService.updateByKeyDynamic(payload));
    }

    /**
     * 人员规划版本-主键查询
     *
     * @folder 人员规划版本
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    @UdcNameClass
    @ApiOperation("人员规划版本-主键查询")
    public TwOutputUtil<PersonPlanVersionVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(personPlanVersionService.queryByKey(key));
    }

    /**
     * 人员规划版本-分页
     *
         * @folder 人员规划版本
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("人员规划版本-分页")
    public TwOutputUtil<PagingVO<PersonPlanVersionVO>> paging(PersonPlanVersionQuery query) {
        return TwOutputUtil.ok(personPlanVersionService.queryPaging(query));
    }

    /**
     * 人员规划版本-查询列表
     *
     * @folder 人员规划版本
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    @UdcNameClass
    @ApiOperation("人员规划版本-查询列表")
    public TwOutputUtil<List<PersonPlanVersionVO>> queryList(PersonPlanVersionQuery query) {
        return TwOutputUtil.ok(personPlanVersionService.queryListDynamic(query));
    }

    /**
     * 人员规划版本-删除
     *
         * @folder 人员规划版本
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("人员规划版本-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
         personPlanVersionService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}

