package com.elitesland.tw.tw5.server.prd.personplan.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;

@Entity
@Table(name = "person_plan_tmp")
@org.hibernate.annotations.Table(appliesTo = "person_plan_tmp", comment = "人员规划临时表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag = 0")
public class PersonPlanTmpDO extends BaseModel {

    @Comment("项目ID")
    @Column()
    private Long projectId;

    @Comment("资源ID")
    @Column()
    private Long resId;

    @Comment("规划明细ID")
    @Column()
    private Long planDtlId;

    @Comment("规划资源")
    @Column()
    private String resName;

    @Comment("规划总人天")
    @Column()
    private BigDecimal days;

    @Comment("年")
    @Column()
    private Integer year;

    @Comment("月")
    @Column()
    private Integer month;

}
