package com.elitesland.tw.tw5.server.prd.pms.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsResourcePlanRolePayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsResourcePlanRoleQuery;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsResourcePlanRoleVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsResourcePlanRoleDO;
import com.elitesland.tw.tw5.server.prd.pms.entity.QPmsResourcePlanRoleDO;
import com.elitesland.tw.tw5.server.prd.pms.repo.PmsResourcePlanRoleRepo;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 资源计划角色明细
 *
 * @author xxb
 * @date 2023-08-11
 */
@Repository
@RequiredArgsConstructor
public class PmsResourcePlanRoleDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final PmsResourcePlanRoleRepo repo;
    private final QPmsResourcePlanRoleDO qdo = QPmsResourcePlanRoleDO.pmsResourcePlanRoleDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PmsResourcePlanRoleVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(PmsResourcePlanRoleVO.class,
                qdo.id,
                qdo.remark,
                qdo.createUserId,
                qdo.creator,
                qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                qdo.modifyTime,
                // 关联资源计划ID
                qdo.planId,
                // 角色
                qdo.role,
                // 复合能力级别ID
                qdo.capasetLevelId,
                // 资源
                qdo.resId,
                // 资源状态
                qdo.planRoleStatus,
                // 派发系数
                qdo.distributeRate,
                // 开始日期
                qdo.startDate,
                // 结束日期
                qdo.endDate,
                // 汇总人天
                qdo.totalDays,
                // 汇总当量
                qdo.totalEqva,
                // 隐藏标志
                qdo.hiddenFlag,
                // 推荐资源id
                qdo.recommendResId,
                // 读取状态
                qdo.readStatus,
                // 预计日期
                qdo.expectedDate
        )).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<PmsResourcePlanRoleVO> getJpaQueryWhere(PmsResourcePlanRoleQuery query) {
        JPAQuery<PmsResourcePlanRoleVO> jpaQuery = getJpaQuerySelect();
        // 条件封装
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        List<OrderItem> orderse = new ArrayList<>();
        orderse.add(OrderItem.asc("createTime"));
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, orderse));
        return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(PmsResourcePlanRoleQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
                .select(qdo.count())
                .from(qdo);
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(PmsResourcePlanRoleQuery query) {
        List<Predicate> list = new ArrayList<>();
        /** 记录唯一ID 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 关联资源计划ID 精确 */
        if (!ObjectUtils.isEmpty(query.getPlanId())) {
            list.add(qdo.planId.eq(query.getPlanId()));
        }
        /** 关联资源计划ID 精确 */
        if (!ObjectUtils.isEmpty(query.getPlanIdList())) {
            list.add(qdo.planId.in(query.getPlanIdList()));
        }
        /** 角色 精确 */
        if (!ObjectUtils.isEmpty(query.getRole())) {
            list.add(qdo.role.eq(query.getRole()));
        }
        /** 复合能力级别ID 精确 */
        if (!ObjectUtils.isEmpty(query.getCapasetLevelId())) {
            list.add(qdo.capasetLevelId.eq(query.getCapasetLevelId()));
        }
        /** 资源 精确 */
        if (!ObjectUtils.isEmpty(query.getResId())) {
            list.add(qdo.resId.eq(query.getResId()));
        }
        /** 资源状态 精确 */
        if (!ObjectUtils.isEmpty(query.getPlanRoleStatus())) {
            list.add(qdo.planRoleStatus.eq(query.getPlanRoleStatus()));
        }
        /** 派发系数 精确 */
        if (!ObjectUtils.isEmpty(query.getDistributeRate())) {
            list.add(qdo.distributeRate.eq(query.getDistributeRate()));
        }
        /** 开始日期 精确 */
        if (!ObjectUtils.isEmpty(query.getStartDate())) {
            list.add(qdo.startDate.eq(query.getStartDate()));
        }
        /** 结束日期 精确 */
        if (!ObjectUtils.isEmpty(query.getEndDate())) {
            list.add(qdo.endDate.eq(query.getEndDate()));
        }
        /** 汇总人天 精确 */
        if (!ObjectUtils.isEmpty(query.getTotalDays())) {
            list.add(qdo.totalDays.eq(query.getTotalDays()));
        }
        /** 汇总当量 精确 */
        if (!ObjectUtils.isEmpty(query.getTotalEqva())) {
            list.add(qdo.totalEqva.eq(query.getTotalEqva()));
        }
        /** 隐藏标志 精确 */
        if (!ObjectUtils.isEmpty(query.getHiddenFlag())) {
            list.add(qdo.hiddenFlag.eq(query.getHiddenFlag()));
        }
//        /** 推荐资源id 精确 */
//        if (!ObjectUtils.isEmpty(query.getRecommendResId())) {
//            list.add(qdo.recommendResId.eq(query.getRecommendResId()));
//        }
//        /** 读取状态 精确 */
//        if (!ObjectUtils.isEmpty(query.getReadStatus())) {
//            list.add(qdo.readStatus.eq(query.getReadStatus()));
//        }
//        /** 预计日期 精确 */
//        if (!ObjectUtils.isEmpty(query.getExpectedDate())) {
//            list.add(qdo.expectedDate.eq(query.getExpectedDate()));
//        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public PmsResourcePlanRoleVO queryByKey(Long id) {
        JPAQuery<PmsResourcePlanRoleVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<PmsResourcePlanRoleVO> queryListDynamic(PmsResourcePlanRoleQuery query) {
        JPAQuery<PmsResourcePlanRoleVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<PmsResourcePlanRoleVO> queryPaging(PmsResourcePlanRoleQuery query) {
        long total = count(query);
        if (total == 0) {
            return PagingVO.empty();
        }
        JPAQuery<PmsResourcePlanRoleVO> jpaQuery = getJpaQueryWhere(query);
        List<PmsResourcePlanRoleVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<PmsResourcePlanRoleVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public PmsResourcePlanRoleDO save(PmsResourcePlanRoleDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<PmsResourcePlanRoleDO> saveAll(List<PmsResourcePlanRoleDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(PmsResourcePlanRolePayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(payload.getId()));
        // 记录唯一ID
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 关联资源计划ID
        if (payload.getPlanId() != null) {
            update.set(qdo.planId, payload.getPlanId());
        }
        // 角色
        if (payload.getRole() != null) {
            update.set(qdo.role, payload.getRole());
        }
        // 复合能力级别ID
        if (payload.getCapasetLevelId() != null) {
            update.set(qdo.capasetLevelId, payload.getCapasetLevelId());
        }
        // 资源
        if (payload.getResId() != null) {
            update.set(qdo.resId, payload.getResId());
        }
        // 资源状态
        if (payload.getPlanRoleStatus() != null) {
            update.set(qdo.planRoleStatus, payload.getPlanRoleStatus());
        }
        // 派发系数
        if (payload.getDistributeRate() != null) {
            update.set(qdo.distributeRate, payload.getDistributeRate());
        }
        // 开始日期
        if (payload.getStartDate() != null) {
            update.set(qdo.startDate, payload.getStartDate());
        }
        // 结束日期
        if (payload.getEndDate() != null) {
            update.set(qdo.endDate, payload.getEndDate());
        }
        // 汇总人天
        if (payload.getTotalDays() != null) {
            update.set(qdo.totalDays, payload.getTotalDays());
        }
        // 汇总当量
        if (payload.getTotalEqva() != null) {
            update.set(qdo.totalEqva, payload.getTotalEqva());
        }
        // 隐藏标志
        if (payload.getHiddenFlag() != null) {
            update.set(qdo.hiddenFlag, payload.getHiddenFlag());
        }
//        // 推荐资源id
//        if (payload.getRecommendResId() != null) {
//            update.set(qdo.recommendResId, payload.getRecommendResId());
//        }
//        // 读取状态
//        if (payload.getReadStatus() != null) {
//            update.set(qdo.readStatus, payload.getReadStatus());
//        }
//        // 预计日期
//        if (payload.getExpectedDate() != null) {
//            update.set(qdo.expectedDate, payload.getExpectedDate());
//        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 记录唯一ID
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 关联资源计划ID
            if (nullFields.contains("planId")) {
                update.setNull(qdo.planId);
            }
            // 角色
            if (nullFields.contains("role")) {
                update.setNull(qdo.role);
            }
            // 复合能力级别ID
            if (nullFields.contains("capasetLevelId")) {
                update.setNull(qdo.capasetLevelId);
            }
            // 资源
            if (nullFields.contains("resId")) {
                update.setNull(qdo.resId);
            }
            // 资源状态
            if (nullFields.contains("planRoleStatus")) {
                update.setNull(qdo.planRoleStatus);
            }
            // 派发系数
            if (nullFields.contains("distributeRate")) {
                update.setNull(qdo.distributeRate);
            }
            // 开始日期
            if (nullFields.contains("startDate")) {
                update.setNull(qdo.startDate);
            }
            // 结束日期
            if (nullFields.contains("endDate")) {
                update.setNull(qdo.endDate);
            }
            // 汇总人天
            if (nullFields.contains("totalDays")) {
                update.setNull(qdo.totalDays);
            }
            // 汇总当量
            if (nullFields.contains("totalEqva")) {
                update.setNull(qdo.totalEqva);
            }
            // 隐藏标志
            if (nullFields.contains("hiddenFlag")) {
                update.setNull(qdo.hiddenFlag);
            }
            // 推荐资源id
            if (nullFields.contains("recommendResId")) {
                update.setNull(qdo.recommendResId);
            }
            // 读取状态
            if (nullFields.contains("readStatus")) {
                update.setNull(qdo.readStatus);
            }
            // 预计日期
            if (nullFields.contains("expectedDate")) {
                update.setNull(qdo.expectedDate);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

    /**
     * 角色 显示 或隐藏
     *
     * @param keys
     * @param hiddenFlag
     * @return
     */
    public long hiddenRole(List<Long> keys, Integer hiddenFlag) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.hiddenFlag, hiddenFlag)
                .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

}

