package com.elitesland.tw.tw5.server.prd.pms.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import javax.validation.constraints.*;
import java.time.LocalDateTime;

/**
 * 派发响应
 *
 * @author xxb
 * @date 2023-10-08
 */
@Entity
@Table(name = "pms_distribute_respond", indexes = {
        @Index(name = "dist_index", columnList = "dist_id")
})
@org.hibernate.annotations.Table(appliesTo = "pms_distribute_respond", comment = "派发响应")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PmsDistributeRespondDO extends BaseModel implements Serializable  {
    /** 派发ID */
    @Comment("派发ID")
    @Column(name = "dist_id")
    private Long distId;
    /** 派发对象 */
    @Comment("派发对象")
    @Column()
    private String reasonName;
    /** 派发人 */
    @Comment("派发人")
    @Column()
    private Long disterResId;
    /** 响应状态 */
    @Comment("响应状态")
    @Column()
    private String respStatus;
    /** 响应时间 */
    @Comment("响应时间")
    @Column()
    private LocalDateTime respTime;
    /** 响应描述 */
    @Comment("响应描述")
    @Column()
    private String respDesc;
    /** 是否邀请 */
    @Comment("是否邀请")
    @Column()
    private Integer inviteFlag;
    /** 响应资源ID */
    @Comment("响应资源ID")
    @Column()
    private Long respondentResId;

    public void copy(PmsDistributeRespondDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
