package com.elitesland.tw.tw5.server.prd.purchase.controller;

import com.elitesland.tw.tw5.api.prd.purchase.payload.SettleApplyPayload;
import com.elitesland.tw.tw5.api.prd.purchase.query.SettleApplyQuery;
import com.elitesland.tw.tw5.api.prd.purchase.vo.SettleApplyVO;
import com.elitesland.tw.tw5.api.prd.purchase.service.SettleApplyService;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitescloud.cloudt.common.base.PagingVO;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 结算申请
 *
 * @folder 结算申请
 * @author wangly
 * @date 2024-08-21
 */
@Api(tags = "结算申请")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/settleApply")
@Slf4j
public class SettleApplyController {

private final SettleApplyService settleApplyService;

    /**
     * 结算申请-新增
     *
     * @folder 结算申请
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("结算申请-新增")
    public TwOutputUtil<SettleApplyVO> insert(@RequestBody SettleApplyPayload payload){
         return TwOutputUtil.ok(settleApplyService.insert(payload));
    }

    /**
     * 结算申请-更新
     *
         * @folder 结算申请
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("结算申请-更新")
    public TwOutputUtil<SettleApplyVO> update(@RequestBody SettleApplyPayload payload){
        return TwOutputUtil.ok(settleApplyService.update(payload));
    }

    /**
     * 结算申请-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @folder 结算申请
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("结算申请-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody SettleApplyPayload payload){
        return TwOutputUtil.ok(settleApplyService.updateByKeyDynamic(payload));
    }

    /**
     * 结算申请-主键查询
     *
     * @folder 结算申请
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    @UdcNameClass
    @ApiOperation("结算申请-主键查询")
    public TwOutputUtil<SettleApplyVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(settleApplyService.queryByKey(key));
    }

    /**
     * 结算申请-分页
     *
         * @folder 结算申请
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("结算申请-分页")
    public TwOutputUtil<PagingVO<SettleApplyVO>> paging(SettleApplyQuery query) {
        return TwOutputUtil.ok(settleApplyService.queryPaging(query));
    }

    /**
     * 结算申请-查询列表
     *
     * @folder 结算申请
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    @UdcNameClass
    @ApiOperation("结算申请-查询列表")
    public TwOutputUtil<List<SettleApplyVO>> queryList(SettleApplyQuery query) {
        return TwOutputUtil.ok(settleApplyService.queryListDynamic(query));
    }

    /**
     * 结算申请-删除
     *
         * @folder 结算申请
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("结算申请-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
         settleApplyService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}

